/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.recipe.composer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.JsonContext;
import yuudaari.soulus.common.block.composer.ComposerTileEntity;
import yuudaari.soulus.common.recipe.Recipe;
import yuudaari.soulus.common.recipe.RecipeUtils;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;
import yuudaari.soulus.common.util.JSON;
import yuudaari.soulus.common.util.Logger;

public class RecipeComposerShaped
extends Recipe
implements IRecipeComposer,
IShapedRecipe {
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    @Nonnull
    protected ItemStack output = ItemStack.field_190927_a;
    protected NonNullList<Ingredient> input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;
    protected final float time;
    protected final Map<String, Integer> mobsRequired = new HashMap<String, Integer>();
    protected final Set<String> mobWhitelist = new HashSet<String>();
    protected final Set<String> mobBlacklist = new HashSet<String>();

    public RecipeComposerShaped(ItemStack result, float time, Map<String, Integer> mobsRequired, Set<String> mobWhitelist, Set<String> mobBlacklist, Object ... recipe) {
        this(result, time, mobsRequired, mobWhitelist, mobBlacklist, CraftingHelper.parseShaped((Object[])recipe));
    }

    private RecipeComposerShaped(ItemStack result, float time, Map<String, Integer> requiredMobs, Set<String> whitelist, Set<String> blacklist, CraftingHelper.ShapedPrimer primer) {
        this.output = result.func_77946_l();
        this.width = primer.width;
        this.height = primer.height;
        this.input = primer.input;
        this.mirrored = primer.mirrored;
        this.time = time;
        if (requiredMobs != null) {
            this.mobsRequired.putAll(requiredMobs);
        }
        if (whitelist != null) {
            this.mobWhitelist.addAll(whitelist);
        }
        if (blacklist != null) {
            this.mobBlacklist.addAll(blacklist);
        }
    }

    @Override
    public float getTime() {
        return this.time;
    }

    @Override
    public Map<String, Integer> getMobsRequired() {
        return this.mobsRequired;
    }

    @Override
    public Set<String> getMobWhitelist() {
        return this.mobWhitelist;
    }

    @Override
    public Set<String> getMobBlacklist() {
        return this.mobBlacklist;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        if (!(inv instanceof ComposerTileEntity.ComposerContainer.CraftingMatrix)) {
            return false;
        }
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.field_193370_a;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? (Ingredient)this.input.get(this.width - subX - 1 + subY * this.width) : (Ingredient)this.input.get(subX + subY * this.width);
                }
                if (target.apply(inv.func_70463_b(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public RecipeComposerShaped setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            HashMap ingMap = Maps.newHashMap();
            for (Map.Entry entry2 : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                if (((String)entry2.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry2.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry2.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                ingMap.put(Character.valueOf(((String)entry2.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry2.getValue()), (JsonContext)context));
            }
            ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
            JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
            if (patternJ.size() == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
                if (x > 0 && pattern[0].length() != line.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                pattern[x] = line;
            }
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = pattern[0].length();
            primer.height = pattern.length;
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
            HashSet keys = Sets.newHashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    primer.input.set(x++, (Object)ing);
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                Logger.warn("Key defines symbols that aren't used in pattern: " + keys);
            }
            ItemStack output = RecipeUtils.getOutput(json.get("result"), context);
            float time = JsonUtils.func_151221_a((JsonObject)json, (String)"time", (float)1.0f);
            JsonObject mobs = JsonUtils.func_151218_a((JsonObject)json, (String)"mobs_required", null);
            Map<String, Integer> requiredMobs = mobs == null ? null : mobs.getAsJsonObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).getAsInt()));
            Set<String> whitelist = JSON.getStringSet(json, "mob_whitelist");
            Set<String> blacklist = JSON.getStringSet(json, "mob_blacklist");
            return new RecipeComposerShaped(output, time, requiredMobs, whitelist, blacklist, primer);
        }
    }
}

