/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import yuudaari.soulus.common.recipe.RecipeShaped;
import yuudaari.soulus.common.recipe.RecipeShapeless;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;

@Mod.EventBusSubscriber
public class RecipeUtils {
    public static ItemStack getOutput(JsonElement resultProperty, JsonContext context) {
        if (resultProperty.isJsonObject()) {
            return RecipeUtils.getOreDictItem(resultProperty.getAsJsonObject(), context);
        }
        if (resultProperty.isJsonArray()) {
            for (JsonElement entry : resultProperty.getAsJsonArray()) {
                if (!resultProperty.isJsonObject()) continue;
                try {
                    return RecipeUtils.getOutput(entry, context);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                }
            }
        }
        throw new JsonSyntaxException("Invalid recipe output.");
    }

    private static ItemStack getOreDictItem(JsonObject result, JsonContext context) {
        if (JsonUtils.func_151219_a((JsonObject)result, (String)"type", (String)"").equals("forge:ore_dict")) {
            String ore = JsonUtils.func_151200_h((JsonObject)result, (String)"ore");
            ItemStack stack = OreDictionary.getOres((String)ore).stream().findAny().orElse(ItemStack.field_190927_a).func_77946_l();
            stack.func_190920_e(JsonUtils.func_151208_a((JsonObject)result, (String)"count", (int)1));
            int data = JsonUtils.func_151208_a((JsonObject)result, (String)"data", (int)-1);
            if (data > -1) {
                stack.func_77964_b(data);
            }
            return stack;
        }
        return CraftingHelper.getItemStack((JsonObject)result, (JsonContext)context);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable registry = (IForgeRegistryModifiable)event.getRegistry();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (IRecipe recipe : registry) {
            boolean isSoulusRecipe = recipe instanceof IRecipeComposer || recipe instanceof RecipeShaped || recipe instanceof RecipeShapeless || recipe.getRegistryName().func_110624_b().equalsIgnoreCase("soulus");
            if (!isSoulusRecipe || !recipe.func_77571_b().func_190926_b()) continue;
            toRemove.add(recipe.getRegistryName());
        }
        for (ResourceLocation name : toRemove) {
            registry.remove(name);
        }
    }
}

