/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import yuudaari.soulus.common.recipe.Recipe;

public class RecipeShapeless
extends Recipe {
    @Nonnull
    protected ItemStack output = ItemStack.field_190927_a;
    protected NonNullList<Ingredient> input = NonNullList.func_191196_a();

    public RecipeShapeless(ResourceLocation group, Block result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public RecipeShapeless(ResourceLocation group, Item result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public RecipeShapeless(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
        this.output = result.func_77946_l();
        this.group = group;
        this.input = input;
    }

    public RecipeShapeless(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        this.group = group;
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            Ingredient ing = CraftingHelper.getIngredient((Object)in);
            if (ing == null) {
                String ret = "Invalid shapeless ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            this.input.add((Object)ing);
        }
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting var1, @Nonnull World world) {
        NonNullList required = NonNullList.func_191196_a();
        required.addAll(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                if (!((Ingredient)req.next()).apply(slot)) continue;
                inRecipe = true;
                req.remove();
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size();
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            String override = JsonUtils.func_151219_a((JsonObject)json, (String)"override", (String)"");
            NonNullList ings = NonNullList.func_191196_a();
            for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
            }
            if (ings.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            RecipeShapeless result = new RecipeShapeless(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ings, itemstack);
            if (!override.isEmpty()) {
                result.setRegistryName(override);
            }
            return result;
        }
    }
}

