/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.network.packet.client;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.config.Config;

public class SendConfig
implements IMessage {
    private final Map<String, String> configs;

    public SendConfig() {
        this.configs = new HashMap<String, String>();
    }

    public SendConfig(Map<String, String> configs) {
        this.configs = configs;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.configs.size());
        for (Map.Entry<String, String> entry : this.configs.entrySet()) {
            buf.writeInt(entry.getKey().length());
            buf.writeBytes(entry.getKey().getBytes());
            buf.writeInt(entry.getValue().length());
            buf.writeBytes(entry.getValue().getBytes());
        }
    }

    public void fromBytes(ByteBuf buf) {
        for (int l = buf.readInt(); l > 0; --l) {
            String key = buf.readBytes(buf.readInt()).toString(Charset.defaultCharset());
            String val = buf.readBytes(buf.readInt()).toString(Charset.defaultCharset());
            this.configs.put(key, val);
        }
    }

    public static class Handler
    implements IMessageHandler<SendConfig, IMessage> {
        public IMessage onMessage(SendConfig message, MessageContext ctx) {
            Config config = Config.INSTANCES.get("soulus");
            config.SERVER_CONFIGS.clear();
            config.SERVER_CONFIGS.putAll(message.configs);
            Soulus.reloadConfigs(true, false);
            return null;
        }
    }
}

