/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yuudaari.soulus.common.item.Essence;
import yuudaari.soulus.common.recipe.ingredient.IngredientPotentialEssence;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.EssenceType;

public class EssencePerfect
extends Registration.Item {
    @Nullable
    public static String[] getEssenceTypes(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b("essence_types", 9)) {
            return new String[0];
        }
        NBTTagList list = tag.func_150295_c("essence_types", 8);
        return (String[])Streams.stream((Iterable)list).map(strTag -> ((NBTTagString)strTag).func_150285_a_()).toArray(String[]::new);
    }

    public static ItemStack setEssenceTypes(ItemStack stack, ResourceLocation ... essenceTypes) {
        return EssencePerfect.setEssenceTypes(stack, (String[])Arrays.stream(essenceTypes).map(rl -> rl.toString()).toArray(String[]::new));
    }

    public static ItemStack setEssenceTypes(ItemStack stack, String ... essenceTypes) {
        NBTTagList essenceTypesTag = new NBTTagList();
        for (String essenceType : essenceTypes) {
            essenceTypesTag.func_74742_a((NBTBase)new NBTTagString(essenceType));
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74782_a("essence_types", (NBTBase)essenceTypesTag);
        return stack;
    }

    public EssencePerfect() {
        super("essence_perfect");
        this.setMaxStackSize(64);
        this.setHasDescription();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.registerColorHandler((stack, tintIndex) -> {
                String[] essenceTypes = EssencePerfect.getEssenceTypes(stack);
                if (essenceTypes.length == 0) {
                    return -1;
                }
                String essenceType = essenceTypes[tintIndex % essenceTypes.length];
                return Essence.getColor(essenceType, tintIndex % 2);
            });
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack result = this.getItemStack();
        EssencePerfect.setEssenceTypes(result, EntityList.field_75627_a.keySet().toArray(new ResourceLocation[0]));
        items.add((Object)result);
    }

    @Override
    public void onRegisterRecipes(IForgeRegistry<IRecipe> registry) {
        registry.registerAll((IForgeRegistryEntry[])new IRecipe[]{new EssencePerfectRecipe(this.getRegistryName()), new EssencePerfectCombinationRecipe(this.getRegistryName(), 2), new EssencePerfectCombinationRecipe(this.getRegistryName(), 3)});
    }

    public static class EssencePerfectCombinationRecipe
    extends ShapelessOreRecipe {
        private static NonNullList<Ingredient> ingredients(int size) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.addAll(Collections.nCopies(size * size, Ingredient.func_193367_a((Item)ItemRegistry.ESSENCE_PERFECT)));
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients.toArray(new Ingredient[0]));
        }

        public EssencePerfectCombinationRecipe(ResourceLocation name, int size) {
            super(new ResourceLocation(""), EssencePerfectCombinationRecipe.ingredients(size), ItemRegistry.ESSENCE_PERFECT.getItemStack(size * size));
            this.setRegistryName(name + "_combination");
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return !this.func_77572_b(inv).func_190926_b();
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            HashSet essenceTypes = new HashSet();
            int inventorySize = inv.func_70302_i_();
            int quantity = 0;
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                Item stackItem = stack.func_77973_b();
                if (stack == null || stackItem == Items.field_190931_a) continue;
                if (stackItem != ItemRegistry.ESSENCE_PERFECT) {
                    return ItemStack.field_190927_a;
                }
                ++quantity;
                essenceTypes.addAll(Lists.newArrayList((Object[])EssencePerfect.getEssenceTypes(stack)));
            }
            ItemStack result = new ItemStack((Item)ItemRegistry.ESSENCE_PERFECT);
            result.func_190920_e(quantity);
            EssencePerfect.setEssenceTypes(result, essenceTypes.toArray(new String[0]));
            return result;
        }
    }

    public static class EssencePerfectRecipe
    extends ShapelessOreRecipe {
        private static NonNullList<Ingredient> ingredients() {
            ArrayList<IngredientPotentialEssence> ingredients = new ArrayList<IngredientPotentialEssence>();
            ingredients.addAll(Collections.nCopies(9, IngredientPotentialEssence.getInstance()));
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients.toArray(new Ingredient[0]));
        }

        public EssencePerfectRecipe(ResourceLocation name) {
            super(new ResourceLocation(""), EssencePerfectRecipe.ingredients(), ItemRegistry.ESSENCE_PERFECT.getItemStack());
            this.setRegistryName(name);
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return !this.func_77572_b(inv).func_190926_b();
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            HashSet<String> essenceTypes = new HashSet<String>();
            int inventorySize = inv.func_70302_i_();
            if (inventorySize < 9) {
                return ItemStack.field_190927_a;
            }
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                Item stackItem = stack.func_77973_b();
                if (stack == null || stackItem != ItemRegistry.ESSENCE) {
                    return ItemStack.field_190927_a;
                }
                essenceTypes.add(EssenceType.getEssenceType(stack));
            }
            if (essenceTypes.size() < 9) {
                return ItemStack.field_190927_a;
            }
            ItemStack result = new ItemStack((Item)ItemRegistry.ESSENCE_PERFECT);
            result.func_190920_e(1);
            EssencePerfect.setEssenceTypes(result, essenceTypes.toArray(new String[0]));
            return result;
        }
    }
}

