/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yuudaari.soulus.client.util.ParticleType;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.item.ConfigCrystalBlood;
import yuudaari.soulus.common.misc.ModDamageSource;
import yuudaari.soulus.common.network.SoulsPacketHandler;
import yuudaari.soulus.common.network.packet.client.CrystalBloodHitEntity;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Colour;
import yuudaari.soulus.common.util.ModPotionEffect;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class CrystalBlood
extends Registration.Item {
    @ConfigInjected.Inject
    public static ConfigCrystalBlood CONFIG;
    private static final int colourEmpty = 2626323;
    private static final int colourFilled = 12329028;

    public CrystalBlood() {
        super("crystal_blood");
        this.setHasDescription();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.registerColorHandler((stack, tintIndex) -> {
                float percentage = (float)CrystalBlood.getContainedBlood(stack) / (float)CrystalBlood.CONFIG.requiredBlood;
                return Colour.mix(2626323, 12329028, (double)percentage).get();
            });
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return CrystalBlood.getContainedBlood(stack) >= CrystalBlood.CONFIG.requiredBlood ? CrystalBlood.CONFIG.stackSize : 1;
    }

    public ItemStack getFilledStack() {
        return this.getStack(CrystalBlood.CONFIG.requiredBlood);
    }

    public ItemStack getStack(int blood) {
        ItemStack stack = new ItemStack((Item)this);
        CrystalBlood.setContainedBlood(stack, blood);
        return stack;
    }

    @Override
    public ItemStack getItemStack() {
        return this.getStack(0);
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        int containedBlood = CrystalBlood.getContainedBlood(stack);
        return containedBlood >= CrystalBlood.CONFIG.requiredBlood;
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack stack) {
        int containedBlood = CrystalBlood.getContainedBlood(stack);
        String name = super.func_77657_g(stack);
        return containedBlood >= CrystalBlood.CONFIG.requiredBlood ? name + ".filled" : name;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return CrystalBlood.getContainedBlood(stack) < CrystalBlood.CONFIG.requiredBlood;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)Math.min(CrystalBlood.CONFIG.requiredBlood, CrystalBlood.getContainedBlood(stack)) / (double)CrystalBlood.CONFIG.requiredBlood;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        int containedBlood = CrystalBlood.getContainedBlood(heldItem);
        if (containedBlood < CrystalBlood.CONFIG.requiredBlood) {
            if (player instanceof FakePlayer) {
                heldItem.func_190920_e(0);
                EntityItem dropEntity = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, ItemRegistry.CRYSTAL_BLOOD_BROKEN.getItemStack());
                dropEntity.func_174868_q();
                player.field_70170_p.func_72838_d((Entity)dropEntity);
            } else {
                if (!worldIn.field_72995_K) {
                    CrystalBlood.setContainedBlood(heldItem, containedBlood + CrystalBlood.CONFIG.prickWorth);
                    player.func_70097_a(ModDamageSource.CRYSTAL_BLOOD, (float)CrystalBlood.CONFIG.prickAmount);
                    Advancements.CRYSTAL_BLOOD_PRICK.trigger(player, null);
                    for (ModPotionEffect effect : CrystalBlood.CONFIG.prickEffects) {
                        effect.apply((EntityLivingBase)player);
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
                }
                if (player.field_70170_p.field_72995_K) {
                    CrystalBlood.particles((EntityLivingBase)player);
                }
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (target.func_110143_aJ() <= (float)CrystalBlood.CONFIG.creaturePrickRequiredHealth) {
            target.func_70097_a(ModDamageSource.CRYSTAL_BLOOD, (float)CrystalBlood.CONFIG.creaturePrickAmount);
            int blood = CrystalBlood.getContainedBlood(stack);
            CrystalBlood.setContainedBlood(stack, blood + CrystalBlood.CONFIG.creaturePrickWorth);
            CrystalBlood.bloodParticles(target);
        }
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        int containedBlood;
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND && (containedBlood = CrystalBlood.getContainedBlood(stack)) < CrystalBlood.CONFIG.requiredBlood) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 0.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", 0.0, 0));
        }
        return multimap;
    }

    public static int getContainedBlood(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("contained_blood", 3)) {
            return tag.func_74762_e("contained_blood");
        }
        return 0;
    }

    public static boolean isFilled(ItemStack stack) {
        return CrystalBlood.getContainedBlood(stack) >= CrystalBlood.CONFIG.requiredBlood;
    }

    public static ItemStack setContainedBlood(ItemStack stack, int count) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("contained_blood", count);
        return stack;
    }

    public static ItemStack setFilled(ItemStack stack) {
        return CrystalBlood.setContainedBlood(stack, CrystalBlood.CONFIG.requiredBlood);
    }

    public static void bloodParticles(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            CrystalBlood.particles(entity);
        } else {
            SoulsPacketHandler.INSTANCE.sendToAllAround((IMessage)new CrystalBloodHitEntity(entity), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 128.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void particles(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        Random rand = world.field_73012_v;
        for (int i = 0; i < CrystalBlood.CONFIG.particleCount; ++i) {
            double d3 = entity.field_70165_t - 0.5 + (double)rand.nextFloat();
            double d4 = entity.field_70163_u + (double)rand.nextFloat();
            double d5 = entity.field_70161_v - 0.5 + (double)rand.nextFloat();
            double d3o = (d3 - entity.field_70165_t) / 5.0;
            double d4o = (d4 - entity.field_70163_u) / 5.0;
            double d5o = (d5 - entity.field_70161_v) / 5.0;
            world.func_175720_a(ParticleType.BLOOD.getId(), false, d3, d4, d5, d3o, d4o, d5o, new int[]{1});
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.getItemStack());
            items.add((Object)this.getFilledStack());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int containedBlood = CrystalBlood.getContainedBlood(stack);
        if (containedBlood < CrystalBlood.CONFIG.requiredBlood) {
            tooltip.add(new Translation("tooltip.soulus:crystal_blood.contained_blood", new Object[0]).addArgs(containedBlood, CrystalBlood.CONFIG.requiredBlood).get(new Object[0]));
        }
    }
}

