/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.item;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeRepairItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistry;
import yuudaari.soulus.common.registration.IItemRegistration;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.Translation;

public class Barket
extends UniversalBucket
implements IItemRegistration {
    private final ItemStack EMPTY = new ItemStack((Item)this);
    public int field_77699_b = 100;
    public boolean repairable = false;

    public Barket() {
        super(1000, ItemStack.field_190927_a, true);
        this.setName("barket");
        this.setHasDescription();
        this.func_77656_e(this.field_77699_b);
    }

    @Override
    public void onRegisterRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new BarketRepairRecipe().setRegistryName("soulus:barket_repair"));
    }

    public boolean isRepairable() {
        return this.repairable;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.getFluid(itemStack) == null ? 120 : 0;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid == null) {
            return;
        }
        stack.func_77972_a(1, (EntityLivingBase)entityIn);
        if (stack.func_190916_E() == 0 && entityIn instanceof EntityPlayer && !worldIn.field_72995_K) {
            stack.func_190920_e(1);
            FluidUtil.tryPlaceFluid((EntityPlayer)((EntityPlayer)entityIn), (World)worldIn, (BlockPos)entityIn.func_180425_c(), (ItemStack)stack, (FluidStack)fluid);
            stack.func_190920_e(0);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !this.fluidsEqual(oldStack, newStack);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        int durability = itemStack.func_77952_i();
        ItemStack result = super.getContainerItem(itemStack);
        result.func_77964_b(durability);
        return result;
    }

    public boolean fluidsEqual(ItemStack s1, ItemStack s2) {
        FluidStack f1 = this.getFluid(s1);
        FluidStack f2 = this.getFluid(s2);
        return f1 == null ? f2 == null : f1.equals((Object)f2);
    }

    public void func_150895_a(@Nullable CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)this.EMPTY);
        FluidStack fs = new FluidStack(FluidRegistry.WATER, this.getCapacity());
        ItemStack stack = new ItemStack((Item)this);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null && fluidHandler.fill(fs, true) == fs.amount) {
            ItemStack filled = fluidHandler.getContainer();
            subItems.add((Object)filled);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        FluidStack fluidStack = this.getFluid(heldItem);
        if (fluidStack != null) {
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult target = this.func_77621_a(world, player, true);
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        BlockPos pos = target.func_178782_a();
        ItemStack singleBucket = heldItem.func_77946_l();
        singleBucket.func_190920_e(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        if (filledResult.isSuccess()) {
            ItemStack filledBucket = filledResult.result;
            if (player.field_71075_bZ.field_75098_d) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)filledBucket);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledBucket);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
    }

    public String func_77657_g(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        return super.func_77657_g(stack) + (fluidStack == null ? "" : "_filled");
    }

    public String func_77653_i(ItemStack stack) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return Translation.localize(this.func_77657_g(stack) + ".name", new Object[0]);
        }
        return this.getRegistryName().toString();
    }

    public ItemStack getEmpty() {
        return this.EMPTY;
    }

    @Nullable
    public FluidStack getFluid(ItemStack container) {
        return FluidUtil.getFluidContained((ItemStack)container);
    }

    @Override
    public void registerModels() {
        ModelResourceLocation loc = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> loc);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{loc});
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandler(stack, this.getCapacity());
    }

    public static class FluidHandler
    extends FluidHandlerItemStackSimple {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FluidRegistry.WATER;
        }
    }

    public static class BarketRepairRecipe
    extends RecipeRepairItem {
        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            int count = 0;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() == ItemRegistry.BARKET && stack.func_190916_E() == 1 && ++count <= 2) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            ItemRegistry.BARKET.repairable = true;
            ItemStack result = super.func_77572_b(inv);
            ItemRegistry.BARKET.repairable = false;
            return result;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
    }
}

