/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.creature;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import yuudaari.soulus.common.config.creature.ConfigCreatureBiome;
import yuudaari.soulus.common.util.serializer.DefaultMapSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@Serializable
public class ConfigCreatureDimension {
    public String dimensionId;
    @Serialized(value=BiomeMapSerializer.class, topLevel=true)
    public Map<String, ConfigCreatureBiome> biomeConfigs = new HashMap<String, ConfigCreatureBiome>();

    public ConfigCreatureDimension() {
    }

    public ConfigCreatureDimension(String biome, ConfigCreatureBiome config) {
        this.biomeConfigs.put(biome, config);
    }

    public ConfigCreatureDimension(Map<String, ConfigCreatureBiome> configs) {
        this.biomeConfigs.putAll(configs);
        for (Map.Entry<String, ConfigCreatureBiome> entry : this.biomeConfigs.entrySet()) {
            entry.getValue().biomeId = entry.getKey();
        }
    }

    public static class BiomeMapSerializer
    extends DefaultMapSerializer<ConfigCreatureBiome> {
        @Override
        public Class<ConfigCreatureBiome> getValueClass() {
            return ConfigCreatureBiome.class;
        }

        @Override
        public Map<String, ConfigCreatureBiome> deserialize(Class<?> requestedType, JsonElement json) {
            Object result = super.deserialize((Class)requestedType, json);
            if (result == null) {
                return result;
            }
            for (Map.Entry entry : result.entrySet()) {
                ((ConfigCreatureBiome)entry.getValue()).biomeId = (String)entry.getKey();
            }
            return result;
        }
    }
}

