/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.creature;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import yuudaari.soulus.common.config.creature.ConfigCreature;
import yuudaari.soulus.common.util.serializer.DefaultMapSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@Serializable
public class ConfigCreatureBiome {
    public String biomeId;
    @Serialized(value=CreatureMapSerializer.class, topLevel=true)
    public Map<String, ConfigCreature> creatureConfigs = new HashMap<String, ConfigCreature>();

    public ConfigCreatureBiome() {
    }

    public ConfigCreatureBiome(String creature, ConfigCreature config) {
        this.creatureConfigs.put(creature, config);
    }

    public ConfigCreatureBiome(Map<String, ConfigCreature> configs) {
        this.creatureConfigs = configs;
        for (Map.Entry<String, ConfigCreature> entry : configs.entrySet()) {
            entry.getValue().creatureId = entry.getKey();
        }
    }

    public static class CreatureMapSerializer
    extends DefaultMapSerializer<ConfigCreature> {
        @Override
        public Class<ConfigCreature> getValueClass() {
            return ConfigCreature.class;
        }

        @Override
        public Map<String, ConfigCreature> deserialize(Class<?> requestedType, JsonElement json) {
            Object result = super.deserialize((Class)requestedType, json);
            if (result == null) {
                return result;
            }
            for (Map.Entry entry : result.entrySet()) {
                ((ConfigCreature)entry.getValue()).creatureId = (String)entry.getKey();
            }
            return result;
        }
    }
}

