/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.creature;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import yuudaari.soulus.common.config.creature.ConfigCreatureDrops;
import yuudaari.soulus.common.util.serializer.DefaultMapSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@Serializable
public class ConfigCreature {
    public String creatureId;
    @Serialized
    public double spawnChance = 0.0;
    @Serialized(value=DropMapSerializer.class)
    public Map<String, ConfigCreatureDrops> drops = new HashMap<String, ConfigCreatureDrops>();

    public ConfigCreature() {
    }

    public ConfigCreature(double spawnChance) {
        this.spawnChance = spawnChance;
    }

    public ConfigCreature setWhitelistedDrops(String spawnType, String ... whitelistedDrops) {
        ConfigCreatureDrops dc = this.drops.get(spawnType);
        if (dc == null) {
            dc = new ConfigCreatureDrops();
            this.drops.put(spawnType, dc);
        }
        dc.whitelistedDrops = Arrays.asList(whitelistedDrops);
        return this;
    }

    public ConfigCreature setBlacklistedDrops(String spawnType, String ... blacklistedDrops) {
        ConfigCreatureDrops dc = this.drops.get(spawnType);
        if (dc == null) {
            dc = new ConfigCreatureDrops(true);
            this.drops.put(spawnType, dc);
        }
        dc.blacklistedDrops = Arrays.asList(blacklistedDrops);
        return this;
    }

    public static class DropMapSerializer
    extends DefaultMapSerializer<ConfigCreatureDrops> {
        @Override
        public Class<ConfigCreatureDrops> getValueClass() {
            return ConfigCreatureDrops.class;
        }
    }
}

