/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.serializer.ClassSerializationEventHandlers;

public abstract class ConfigUpgradeableBlock<T extends UpgradeableBlock<? extends UpgradeableBlockTileEntity>> {
    protected abstract UpgradeableBlock.IUpgrade[] getUpgrades();

    @ClassSerializationEventHandlers.SerializationEventHandler
    public static void onSerialization(Object instance, JsonObject object) {
        JsonObject result = new JsonObject();
        ConfigUpgradeableBlock config = (ConfigUpgradeableBlock)instance;
        for (UpgradeableBlock.IUpgrade upgrade : config.getUpgrades()) {
            if (!upgrade.canOverrideMaxQuantity()) continue;
            String key = upgrade.getName().toLowerCase();
            result.addProperty(key, (Number)upgrade.getMaxQuantity());
        }
        object.add("max_upgrades", (JsonElement)result);
    }

    @ClassSerializationEventHandlers.DeserializationEventHandler
    public static void onDeserialization(Object instance, JsonObject element) {
        JsonElement from = element.get("max_upgrades");
        if (from == null || !from.isJsonObject()) {
            Logger.warn("Max upgrades must be an object");
            return;
        }
        ConfigUpgradeableBlock config = (ConfigUpgradeableBlock)instance;
        JsonObject upgrades = from.getAsJsonObject();
        for (Map.Entry entry : upgrades.entrySet()) {
            JsonElement val = (JsonElement)entry.getValue();
            if (val == null || !val.isJsonPrimitive() || !val.getAsJsonPrimitive().isNumber()) {
                Logger.warn("Upgrade maximum must be an number");
                continue;
            }
            String key = (String)entry.getKey();
            UpgradeableBlock.IUpgrade upgrade = null;
            for (UpgradeableBlock.IUpgrade checkUpgrade : config.getUpgrades()) {
                if (!key.equalsIgnoreCase(checkUpgrade.getName())) continue;
                if (!checkUpgrade.canOverrideMaxQuantity()) break;
                upgrade = checkUpgrade;
                break;
            }
            if (upgrade == null) {
                Logger.warn("Upgrade type '" + key + "' is invalid");
                continue;
            }
            upgrade.setMaxQuantity(val.getAsInt());
        }
    }
}

