/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import yuudaari.soulus.common.block.EndersteelType;
import yuudaari.soulus.common.block.summoner.Summoner;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.config.ClientField;
import yuudaari.soulus.common.config.ConfigFile;
import yuudaari.soulus.common.config.block.ConfigUpgradeableBlock;
import yuudaari.soulus.common.util.ModPotionEffect;
import yuudaari.soulus.common.util.Range;
import yuudaari.soulus.common.util.serializer.DefaultClassSerializer;
import yuudaari.soulus.common.util.serializer.DefaultFieldSerializer;
import yuudaari.soulus.common.util.serializer.MapSerializer;
import yuudaari.soulus.common.util.serializer.NullableField;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@ConfigFile(file="block/summoner", id="soulus")
@Serializable
public class ConfigSummoner
extends ConfigUpgradeableBlock<Summoner> {
    @Serialized
    @ClientField
    public int particleCountSpawn = 50;
    @Serialized
    @ClientField
    public double particleCountActivated = 3.0;
    @Serialized
    public double perfectEssenceBoost = 0.015;
    @Serialized
    public double perfectEssenceBoostDecay = 0.7;
    @Serialized
    public int nonUpgradedSpawningRadius = 4;
    @Serialized
    public Range nonUpgradedCount = new Range(1, 2);
    @Serialized
    public Range upgradeCountEffectiveness = new Range(0.2, 0.5);
    @Serialized
    public double upgradeCountRadiusEffectiveness = 0.15;
    @Serialized
    public int nonUpgradedRange = 4;
    @Serialized
    public int upgradeRangeEffectiveness = 4;
    @Serialized
    public Range nonUpgradedDelay = new Range(10000, 20000);
    @Serialized
    public Range upgradeDelayEffectiveness = new Range(0.8, 1);
    @Serialized
    public double soulbookEssenceRequiredToInsert = 0.5;
    @Serialized
    @NullableField
    public Integer soulbookUses = 256;
    @Serialized
    public Range efficiencyUpgradeRange = new Range(1, 0.3);
    @Serialized
    public int midnightJewelRange = 16;
    @Serialized
    public Range midnightJewelCount = new Range(2, 4);
    @Serialized
    public Range midnightJewelDelay = new Range(500, 1000);
    @Serialized
    public int midnightJewelSpawningRadius = 4;
    @Serialized
    public Range midnightJewelSoulbookEssenceQuantity = new Range(1, 5);
    @Serialized(value=StylerMapSerializer.class)
    public Map<String, EndersteelType> styleItems = new HashMap<String, EndersteelType>();
    @Serialized(value=PotionEffectsMapSerializer.class)
    public Map<EndersteelType, ModPotionEffect[]> stylePotionEffects;

    public ConfigSummoner() {
        this.styleItems.put("soulus:dust_iron", EndersteelType.NORMAL);
        this.styleItems.put("soulus:dust_wood", EndersteelType.EARTHY);
        this.styleItems.put("soulus:dust_stone", EndersteelType.SPOOKY);
        this.styleItems.put("soulus:dust_ender", EndersteelType.ENDER);
        this.styleItems.put("minecraft:blaze_powder", EndersteelType.BLAZING);
        this.styleItems.put("soulus:dust_niobium", EndersteelType.SORROW);
        this.styleItems.put("soulus:ash", EndersteelType.MADNESS);
        this.stylePotionEffects = new HashMap<EndersteelType, ModPotionEffect[]>();
        this.stylePotionEffects.put(EndersteelType.NORMAL, new ModPotionEffect[]{new ModPotionEffect("water_breathing", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("strength", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("slowness", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("invisibility", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("weakness", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("regeneration", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("speed", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("resistance", Integer.MAX_VALUE, 0.1f)});
        this.stylePotionEffects.put(EndersteelType.SPOOKY, new ModPotionEffect[]{new ModPotionEffect("glowing", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("invisibility", Integer.MAX_VALUE, 0.5f), new ModPotionEffect("wither", Integer.MAX_VALUE, 0.1f)});
        this.stylePotionEffects.put(EndersteelType.EARTHY, new ModPotionEffect[]{new ModPotionEffect("slowness", Integer.MAX_VALUE, 0.2f), new ModPotionEffect("resistance", Integer.MAX_VALUE, 0.5f), new ModPotionEffect("poison", Integer.MAX_VALUE, 0.1f)});
        this.stylePotionEffects.put(EndersteelType.BLAZING, new ModPotionEffect[]{new ModPotionEffect("fire_resistance", Integer.MAX_VALUE, 0.5f), new ModPotionEffect("regeneration", Integer.MAX_VALUE, 0.2f), new ModPotionEffect("weakness", Integer.MAX_VALUE, 0.1f)});
        this.stylePotionEffects.put(EndersteelType.ENDER, new ModPotionEffect[]{new ModPotionEffect("speed", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("absorption", Integer.MAX_VALUE, 0.5f), new ModPotionEffect("strength", Integer.MAX_VALUE, 0.2f)});
        this.stylePotionEffects.put(EndersteelType.SORROW, new ModPotionEffect[]{new ModPotionEffect("slowness", Integer.MAX_VALUE, 0.2f), new ModPotionEffect("weakness", Integer.MAX_VALUE, 0.5f), new ModPotionEffect("resistance", Integer.MAX_VALUE, 0.1f)});
        this.stylePotionEffects.put(EndersteelType.MADNESS, new ModPotionEffect[]{new ModPotionEffect("weakness", Integer.MAX_VALUE, 0.1f), new ModPotionEffect("wither", Integer.MAX_VALUE, 0.5f), new ModPotionEffect("poison", Integer.MAX_VALUE, 0.2f)});
    }

    @Override
    protected UpgradeableBlock.IUpgrade[] getUpgrades() {
        return Summoner.Upgrade.values();
    }

    public static class PotionEffectsMapSerializer
    extends MapSerializer<EndersteelType, ModPotionEffect[]> {
        @Override
        public EndersteelType deserializeKey(String key) {
            return EndersteelType.byName(key);
        }

        @Override
        public String serializeKey(EndersteelType key) {
            return key.func_176610_l();
        }

        @Override
        public JsonElement serializeValue(ModPotionEffect[] value) throws Exception {
            DefaultFieldSerializer serializer = new DefaultFieldSerializer();
            return DefaultClassSerializer.serializeValue(serializer, ModPotionEffect[].class, false, value);
        }

        @Override
        public ModPotionEffect[] deserializeValue(JsonElement value) throws Exception {
            DefaultFieldSerializer deserializer = new DefaultFieldSerializer();
            return (ModPotionEffect[])DefaultClassSerializer.deserializeValue(deserializer, ModPotionEffect[].class, false, value);
        }
    }

    public static class StylerMapSerializer
    extends MapSerializer.OfStringKeys<EndersteelType> {
        @Override
        public JsonElement serializeValue(EndersteelType value) throws Exception {
            return new JsonPrimitive(value.func_176610_l());
        }

        @Override
        public EndersteelType deserializeValue(JsonElement value) throws Exception {
            return EndersteelType.byName(value.getAsString());
        }
    }
}

