/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.compat.jei;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;
import yuudaari.soulus.common.recipe.composer.RecipeComposerShaped;
import yuudaari.soulus.common.util.RegionI;
import yuudaari.soulus.common.util.Translation;
import yuudaari.soulus.common.util.Vec2i;

public class RecipeWrapperComposer
implements IRecipeWrapper {
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private ItemStack output;
    private boolean isShaped = false;
    private float recipeTime = 1.0f;
    private Map<String, Integer> requiredMobs;
    private ResourceLocation registryName;

    public int getWidth() {
        return this.isShaped ? 3 : 0;
    }

    public int getHeight() {
        return this.isShaped ? 3 : 0;
    }

    public boolean isShaped() {
        return this.isShaped;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public RecipeWrapperComposer(IRecipe recipe) {
        for (Ingredient input : recipe.func_192400_c()) {
            this.inputs.add(Arrays.asList(input.func_193365_a()));
        }
        this.output = recipe.func_77571_b();
        this.registryName = recipe.getRegistryName();
        if (recipe instanceof IRecipeComposer) {
            IRecipeComposer composerRecipe = (IRecipeComposer)recipe;
            this.recipeTime = composerRecipe.getTime();
            this.requiredMobs = composerRecipe.getMobsRequired();
        }
        if (recipe instanceof RecipeComposerShaped || recipe instanceof ShapedOreRecipe || recipe instanceof ShapedRecipes) {
            this.isShaped = true;
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String time = this.getTimeString();
        RegionI regionTime = this.getTimeRegion(time);
        minecraft.field_71466_p.func_175065_a(time, (float)regionTime.pos.x, (float)regionTime.pos.y, Color.DARK_GRAY.getRGB(), false);
        if (this.requiredMobs != null && this.requiredMobs.size() > 0) {
            String mobs = this.getMobsString();
            RegionI regionMobs = this.getMobsRegion(mobs);
            minecraft.field_71466_p.func_175065_a(mobs, (float)regionMobs.pos.x, (float)regionMobs.pos.y, Color.DARK_GRAY.getRGB(), false);
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.getTimeRegion().isPosWithin(new Vec2i(mouseX, mouseY))) {
            return Collections.singletonList(Translation.localize("jei.recipe.soulus:composer.recipe_time_tooltip", new Object[0]));
        }
        if (this.requiredMobs != null && this.requiredMobs.size() > 0 && this.getMobsRegion().isPosWithin(new Vec2i(mouseX, mouseY))) {
            return this.requiredMobs.entrySet().stream().map(requiredMob -> new Translation("waila.soulus:composer.required_creature", new Object[0]).get(Translation.localizeEntity((String)requiredMob.getKey()), requiredMob.getValue())).collect(Collectors.toList());
        }
        return super.getTooltipStrings(mouseX, mouseY);
    }

    private String getTimeString() {
        String timeString = "" + this.recipeTime;
        if (timeString.endsWith(".0")) {
            timeString = timeString.substring(0, timeString.length() - 2);
        }
        return Translation.localize("jei.recipe.soulus:composer.recipe_time", timeString);
    }

    private RegionI getTimeRegion() {
        return this.getTimeRegion(this.getTimeString());
    }

    private RegionI getTimeRegion(String timeString) {
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = renderer.func_78256_a(timeString);
        return new RegionI(new Vec2i(72 - stringWidth / 2, 9), new Vec2i(stringWidth, renderer.field_78288_b));
    }

    private String getMobsString() {
        return Translation.localize("jei.recipe.soulus:composer.mobs_required", new Object[0]);
    }

    private RegionI getMobsRegion() {
        return this.getMobsRegion(this.getMobsString());
    }

    private RegionI getMobsRegion(String mobsString) {
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = renderer.func_78256_a(mobsString);
        return new RegionI(new Vec2i(116 - stringWidth, 46), new Vec2i(stringWidth, renderer.field_78288_b));
    }
}

