/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.compat.jei;

import java.text.DecimalFormat;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.bones.ConfigBoneTypes;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.item.Essence;
import yuudaari.soulus.common.misc.BoneChunks;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.EssenceType;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class RecipeCategoryEssence
implements IRecipeCategory<IRecipeWrapper> {
    @ConfigInjected.Inject
    public static ConfigBoneTypes CONFIG;
    public static final String UID = "soulus:essence";
    private static final int craftInputSlot = 0;
    private static final int craftOutputSlot1 = 1;
    public static final int width = 162;
    public static final int height = 105;
    private final IDrawable background;
    private final ICraftingGridHelper craftingGridHelper;

    public RecipeCategoryEssence(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("soulus", "textures/gui/jei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 162, 105);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return Translation.localize("jei.recipe." + this.getUid() + ".name", new Object[0]);
    }

    public String getModName() {
        return "soulus";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 72, 4);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = 1 + x + y * 9;
                guiItemStacks.init(index, true, x * 18, 33 + y * 18);
            }
        }
        if (recipeWrapper instanceof ICustomCraftingRecipeWrapper) {
            ICustomCraftingRecipeWrapper customWrapper = (ICustomCraftingRecipeWrapper)recipeWrapper;
            customWrapper.setRecipe(recipeLayout, ingredients);
            return;
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        guiItemStacks.set(0, (List)inputs.get(0));
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, outputs, 9, 4);
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (ingredient.func_77973_b() == ItemRegistry.ESSENCE) {
                ConfigEssence essence = Essence.CONFIG.get(EssenceType.getEssenceType(ingredient));
                if (essence.bones == null) {
                    return;
                }
                double dropWeight = essence.bones.dropWeight;
                double dropChance = dropWeight / BoneChunks.getChanceTotal(essence.bones.type) * 100.0;
                tooltip.add(0, Translation.localize("jei.recipe.soulus:essence.tooltip_chance", new DecimalFormat("#.##").format(dropChance)));
            }
        });
    }
}

