/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.compat.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.config.Constants;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import yuudaari.soulus.common.compat.jei.RecipeWrapperComposer;
import yuudaari.soulus.common.util.Translation;

public class RecipeCategoryComposer
implements IRecipeCategory<IRecipeWrapper> {
    public static final String UID = "soulus:composer";
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final ICraftingGridHelper craftingGridHelper;

    public RecipeCategoryComposer(IGuiHelper guiHelper) {
        ResourceLocation location = Constants.RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return Translation.localize("jei.recipe." + this.getUid() + ".name", new Object[0]);
    }

    public String getModName() {
        return "soulus";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        Object craftingRecipeWrapper;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        if (recipeWrapper instanceof ICustomCraftingRecipeWrapper) {
            ICustomCraftingRecipeWrapper customWrapper = (ICustomCraftingRecipeWrapper)recipeWrapper;
            customWrapper.setRecipe(recipeLayout, ingredients);
            return;
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else if (recipeWrapper instanceof RecipeWrapperComposer && ((RecipeWrapperComposer)recipeWrapper).isShaped()) {
            RecipeWrapperComposer wrapper = (RecipeWrapperComposer)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
        ResourceLocation registryName = null;
        if (recipeWrapper instanceof ICraftingRecipeWrapper) {
            craftingRecipeWrapper = (ICraftingRecipeWrapper)recipeWrapper;
            registryName = craftingRecipeWrapper.getRegistryName();
        } else if (recipeWrapper instanceof RecipeWrapperComposer) {
            craftingRecipeWrapper = (RecipeWrapperComposer)recipeWrapper;
            registryName = ((RecipeWrapperComposer)craftingRecipeWrapper).getRegistryName();
        }
        if (registryName != null) {
            ResourceLocation actualRegistryName = registryName;
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    boolean showAdvanced;
                    String recipeModId = actualRegistryName.func_110624_b();
                    boolean modIdDifferent = false;
                    ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                    if (itemRegistryName != null) {
                        String itemModId = itemRegistryName.func_110624_b();
                        boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                    }
                    if (modIdDifferent) {
                        String modName = ForgeModIdHelper.getInstance().getFormattedModNameForModId(recipeModId);
                        tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.GRAY + actualRegistryName.func_110623_a());
                    }
                }
            });
        }
    }
}

