/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.compat.crafttweaker;

import com.google.common.collect.Sets;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import yuudaari.soulus.common.compat.crafttweaker.IZenComposerFactory;
import yuudaari.soulus.common.compat.crafttweaker.mtlib.InputHelper;
import yuudaari.soulus.common.compat.crafttweaker.mtlib.LogHelper;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;
import yuudaari.soulus.common.recipe.composer.RecipeComposerShaped;
import yuudaari.soulus.common.recipe.composer.RecipeComposerShapeless;

@ZenClass(value="mods.soulus.Composer")
@ZenRegister
public class ZenComposer {
    public static final String NAME = "mods.soulus.Composer";
    private static final List<IAction> REMOVALS = new ArrayList<IAction>();
    private static final List<IAction> ADDITIONS = new ArrayList<IAction>();

    public static void apply() {
        for (IAction removal : REMOVALS) {
            CraftTweakerAPI.apply((IAction)removal);
        }
        for (IAction addition : ADDITIONS) {
            CraftTweakerAPI.apply((IAction)addition);
        }
    }

    @ZenMethod
    public static Factory recipe(String name, IItemStack output) {
        return new Factory(name, output);
    }

    private static Ingredient getIngredient(IIngredient ingredient) {
        ItemStack[] itemStacks;
        if (ingredient instanceof IOreDictEntry) {
            NonNullList ores = OreDictionary.getOres((String)((IOreDictEntry)ingredient).getName());
            itemStacks = (ItemStack[])ores.toArray((Object[])new ItemStack[ores.size()]);
        } else if (ingredient instanceof IItemStack) {
            itemStacks = new ItemStack[]{InputHelper.toStack((IItemStack)ingredient)};
        } else if (ingredient instanceof IngredientStack) {
            List items = ingredient.getItems();
            itemStacks = new ItemStack[items.size()];
            for (int j = 0; j < items.size(); ++j) {
                itemStacks[j] = InputHelper.toStack((IItemStack)items.get(j));
            }
        } else {
            LogHelper.logError("Unknown input type: " + ingredient);
            return null;
        }
        return Ingredient.func_193369_a((ItemStack[])itemStacks);
    }

    @ZenMethod
    public static void remove(String name) {
        REMOVALS.add(new Remove(name));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        REMOVALS.add(new Remove(InputHelper.toStack(output)));
    }

    public static class Remove
    implements IAction {
        private final Object find;

        public Remove(String name) {
            this.find = name;
        }

        public Remove(ItemStack stack) {
            this.find = stack;
        }

        public String describe() {
            return "Removing composer recipe for " + this.find;
        }

        public void apply() {
            IForgeRegistryModifiable recipes = (IForgeRegistryModifiable)ForgeRegistries.RECIPES;
            if (this.find instanceof ItemStack) {
                List matchingRecipes = recipes.getEntries().stream().filter(r -> r.getValue() instanceof IRecipeComposer && ItemStack.func_77989_b((ItemStack)((IRecipe)r.getValue()).func_77571_b(), (ItemStack)((ItemStack)this.find))).collect(Collectors.toList());
                for (Map.Entry entry : matchingRecipes) {
                    recipes.remove((ResourceLocation)entry.getKey());
                }
            } else {
                recipes.remove(new ResourceLocation((String)this.find));
            }
        }
    }

    public static class Factory
    implements IZenComposerFactory,
    IAction {
        public final String name;
        public final IItemStack output;
        public float time = 1.0f;
        public IIngredient[] inputsShapeless = null;
        public IIngredient[][] inputsShaped = null;
        public Set<String> mobWhitelist = null;
        public Set<String> mobBlacklist = null;
        public Map<String, Integer> mobsRequired = null;

        private Factory(String name, IItemStack output) {
            this.name = name;
            this.output = output;
        }

        @Override
        public Factory setTime(float time) {
            this.time = time;
            return this;
        }

        @Override
        public Factory setShaped(IIngredient[][] inputsShaped) {
            this.inputsShapeless = null;
            this.inputsShaped = inputsShaped;
            return this;
        }

        @Override
        public Factory setShapeless(IIngredient[] inputsShapeless) {
            this.inputsShaped = null;
            this.inputsShapeless = inputsShapeless;
            return this;
        }

        @Override
        public Factory setMobWhitelist(String[] mobWhitelist) {
            this.mobWhitelist = Sets.newHashSet((Object[])mobWhitelist);
            return this;
        }

        @Override
        public Factory setMobBlacklist(String[] mobBlacklist) {
            this.mobBlacklist = Sets.newHashSet((Object[])mobBlacklist);
            return this;
        }

        @Override
        public Factory setMobsRequired(Map<String, Integer> mobsRequired) {
            this.mobsRequired = mobsRequired;
            return this;
        }

        public String describe() {
            return "Adding Composer recipe '" + this.name + "'. Output: " + this.output.getDisplayName();
        }

        @Override
        public void create() {
            ADDITIONS.add(this);
        }

        public void apply() {
            if (this.inputsShapeless == null && this.inputsShaped == null) {
                LogHelper.logError("No ingredients set for recipe: '" + this.name + "'");
                return;
            }
            IRecipe recipe = (this.inputsShaped == null ? this.createShapeless() : this.createShaped()).setRegistryName(new ResourceLocation(this.name));
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        }

        private RecipeComposerShaped createShaped() {
            Stack<Object> ingredients = new Stack<Object>();
            int i = 0;
            for (IIngredient[] inputArr : this.inputsShaped) {
                String row = "";
                for (IIngredient input : inputArr) {
                    char symbol = input == null ? (char)' ' : (char)Character.forDigit(i++, 10);
                    row = row + symbol;
                    if (symbol == ' ' || input == null) continue;
                    ingredients.push(Character.valueOf(symbol));
                    Ingredient ingredient = ZenComposer.getIngredient(input);
                    if (ingredient == null) {
                        LogHelper.logError("Unknown ingredient for symbol '" + symbol + "' in recipe '" + this.name + "'");
                        return null;
                    }
                    ingredients.push(ingredient);
                }
                ingredients.insertElementAt(row, (i - 1) / 3);
            }
            return new RecipeComposerShaped(InputHelper.toStack(this.output), this.time, this.mobsRequired, this.mobWhitelist, this.mobBlacklist, ingredients.toArray(new Object[0]));
        }

        private RecipeComposerShapeless createShapeless() {
            Object[] ingredients = new Ingredient[this.inputsShapeless.length];
            for (int i = 0; i < this.inputsShapeless.length; ++i) {
                ingredients[i] = ZenComposer.getIngredient(this.inputsShapeless[i]);
            }
            return new RecipeComposerShapeless(InputHelper.toStack(this.output), this.time, this.mobsRequired, this.mobWhitelist, this.mobBlacklist, ingredients);
        }
    }
}

