/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.compat;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.util.Logger;

public class GameStages {
    public static boolean tweakConditionMatches(JsonObject condition) {
        if (!Loader.isModLoaded((String)"gamestages")) {
            return false;
        }
        JsonElement playerJson = condition.get("player");
        if (playerJson == null || !playerJson.isJsonPrimitive() || !playerJson.getAsJsonPrimitive().isString()) {
            Logger.warn("GameStages Tweak conditions must have a 'player' property of either 'all' or 'any'.");
            return false;
        }
        JsonElement stagesJson = condition.get("stages");
        if (stagesJson == null || !stagesJson.isJsonArray()) {
            Logger.warn("GameStages Tweak conditions must have a 'stages' property containing a list of stages.");
            return false;
        }
        String playerOption = playerJson.getAsString();
        JsonArray stages = stagesJson.getAsJsonArray();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return false;
        }
        PlayerList playerList = server.func_184103_al();
        if (playerList == null) {
            return false;
        }
        for (EntityPlayer player : server.func_184103_al().func_181057_v()) {
            boolean stagesMatch = GameStages.stagesMatch(player, stages);
            if (playerOption.equalsIgnoreCase("all") && !stagesMatch) {
                return false;
            }
            if (!playerOption.equalsIgnoreCase("any") || !stagesMatch) continue;
            return true;
        }
        return playerOption.equalsIgnoreCase("all");
    }

    private static boolean stagesMatch(EntityPlayer player, JsonArray stagesJson) {
        String[] stages = (String[])Streams.stream((Iterable)stagesJson).map(stage -> stage.isJsonPrimitive() && stage.getAsJsonPrimitive().isString() ? stage.getAsString() : null).toArray(String[]::new);
        try {
            return GameStageHelper.hasAllOf((EntityPlayer)player, (String[])stages);
        }
        catch (Exception e) {
            Logger.error(e);
            Logger.warn("Are your stages invalid? They must be strings.");
            return false;
        }
    }

    @Optional.Method(modid="gamestages")
    @SubscribeEvent
    public void added(GameStageEvent.Added event) {
        this.changed();
    }

    @Optional.Method(modid="gamestages")
    @SubscribeEvent
    public void removed(GameStageEvent.Removed event) {
        this.changed();
    }

    @Optional.Method(modid="gamestages")
    @SubscribeEvent
    public void cleared(GameStageEvent.Cleared event) {
        this.changed();
    }

    private void changed() {
        Soulus.reloadConfigs(true, false);
    }
}

