/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.upgradeable_block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scala.Tuple3;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.registration.IBlockRegistration;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@Mod.EventBusSubscriber(modid="soulus")
public abstract class UpgradeableBlock<TileEntityClass extends UpgradeableBlockTileEntity>
extends Registration.Block {
    public abstract IUpgrade[] getUpgrades();

    public UpgradeableBlock(String name, Material material) {
        super(name, material);
        this.setHasItem();
        this.func_149649_H();
        this.registerWailaProvider(UpgradeableBlock.class);
    }

    public abstract UpgradeableBlock<TileEntityClass> getInstance();

    @SubscribeEvent
    public static final void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        UpgradeableBlock ublock;
        BlockPos pos;
        World world = event.getWorld();
        IBlockState blockState = world.func_180495_p(pos = event.getPos());
        Block block = blockState.func_177230_c();
        if (block instanceof UpgradeableBlock && (ublock = (UpgradeableBlock)block).canActivateWithItem(event.getItemStack(), world, pos)) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static final void onBlockBreak(BlockEvent.BreakEvent event) {
        Block block = event.getState().func_177230_c();
        if (block instanceof UpgradeableBlock) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            EntityPlayer player = event.getPlayer();
            ((UpgradeableBlock)block).onBlockDestroy(world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()), player);
        }
    }

    public final void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.onBlockDestroy(world, pos, 0, null);
    }

    public final void onBlockDestroy(World world, BlockPos pos, @Nullable EntityPlayer player) {
        this.onBlockDestroy(world, pos, 0, player);
    }

    public void onBlockDestroy(World world, BlockPos pos, int fortune, @Nullable EntityPlayer player) {
        List<ItemStack> drops = this.getDropsForBreak(world, pos, world.func_180495_p(pos), fortune, player.func_184812_l_());
        UpgradeableBlock.dropItems(world, drops, pos);
    }

    public final boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack heldStack = player.func_184586_b(hand);
            if (!this.canActivateTileEntity((UpgradeableBlockTileEntity)world.func_175625_s(pos))) {
                return false;
            }
            if (heldStack.func_190926_b()) {
                if (player.func_70093_af()) {
                    return this.onActivateEmptyHandSneaking(world, pos, player);
                }
                return this.onActivateEmptyHand(world, pos, player);
            }
            return this.onActivateInsert(world, pos, player, heldStack);
        }
        return true;
    }

    public boolean onActivateEmptyHandSneaking(World world, BlockPos pos, EntityPlayer player) {
        List<ItemStack> drops = this.getDropsForEmpty(world, pos, world.func_180495_p(pos));
        UpgradeableBlock.returnItemsToPlayer(world, drops, player);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof UpgradeableBlockTileEntity) {
            UpgradeableBlockTileEntity ute = (UpgradeableBlockTileEntity)te;
            ute.clear();
        }
        return true;
    }

    public boolean onActivateEmptyHand(World world, BlockPos pos, EntityPlayer player) {
        return this.onActivateReturnLastUpgrade(world, pos, player);
    }

    public final boolean onActivateReturnLastUpgrade(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof UpgradeableBlockTileEntity)) {
            return false;
        }
        UpgradeableBlockTileEntity ute = (UpgradeableBlockTileEntity)te;
        IUpgrade upgrade = ute.popLastUpgrade();
        if (upgrade == null) {
            return false;
        }
        int count = ute.removeUpgrade(upgrade);
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        upgrade.addItemStackToList(ute, toReturn, count);
        UpgradeableBlock.returnItemsToPlayer(world, toReturn, player);
        return true;
    }

    public boolean onActivateInsert(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        return this.onActivateInsertUpgrade(world, pos, player, stack);
    }

    public final boolean onActivateInsertUpgrade(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof UpgradeableBlockTileEntity)) {
            return false;
        }
        UpgradeableBlockTileEntity ute = (UpgradeableBlockTileEntity)te;
        IUpgrade upgrade = ute.getUpgradeForItem(stack);
        if (upgrade == null) {
            return false;
        }
        int insertQuantity = player.func_70093_af() ? stack.func_190916_E() : 1;
        ute.insertUpgrade(player.func_184812_l_() ? stack.func_77946_l() : stack, upgrade, insertQuantity);
        boolean isFilled = ute.upgrades.get(upgrade).intValue() == upgrade.getMaxQuantity();
        Advancements.UPGRADE.trigger(player, new Tuple3((Object)this, (Object)upgrade, (Object)isFilled));
        return true;
    }

    public final void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    protected static void returnItemsToPlayer(World world, List<ItemStack> items, EntityPlayer player) {
        for (ItemStack item : items) {
            EntityItem dropItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, item);
            dropItem.func_174868_q();
            world.func_72838_d((Entity)dropItem);
        }
    }

    protected static void dropItems(World world, List<ItemStack> items, BlockPos pos) {
        for (ItemStack item : items) {
            EntityItem dropItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, item);
            dropItem.func_174868_q();
            world.func_72838_d((Entity)dropItem);
        }
    }

    public final List<ItemStack> getDropsForBreak(World world, BlockPos pos, IBlockState state, int fortune, boolean creative) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!creative) {
            this.addBlockToList(result, world, pos);
        }
        this.addUpgradeStacksToList(result, world, pos, state);
        this.addOtherDropStacksToList(result, world, pos, state);
        return result;
    }

    public List<ItemStack> getDropsForEmpty(World world, BlockPos pos, IBlockState state) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        this.addUpgradeStacksToList(result, world, pos, state);
        this.addOtherDropStacksToList(result, world, pos, state);
        return result;
    }

    public final void addUpgradeStacksToList(List<ItemStack> list, World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof UpgradeableBlockTileEntity) {
            ((UpgradeableBlockTileEntity)te).addUpgradeStacksToList(list);
        }
    }

    public void addOtherDropStacksToList(List<ItemStack> list, World world, BlockPos pos, IBlockState state) {
    }

    public void addBlockToList(List<ItemStack> list, World world, BlockPos pos) {
        list.add(this.getItemStack());
    }

    public IUpgrade isUpgradeItem(ItemStack stack, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof UpgradeableBlockTileEntity)) {
            return null;
        }
        return ((UpgradeableBlockTileEntity)te).getUpgradeForItem(stack);
    }

    public final boolean canActivateWithItem(ItemStack stack, World world, BlockPos pos) {
        return this.canActivateTileEntity((UpgradeableBlockTileEntity)world.func_175625_s(pos)) && this.canActivateWithStack(stack, world, pos);
    }

    public boolean canActivateWithStack(ItemStack stack, World world, BlockPos pos) {
        return stack.func_190926_b() || this.isUpgradeItem(stack, world, pos) != null;
    }

    public boolean canActivateTileEntity(TileEntityClass te) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public UpgradeableBlockTileEntity createTileEntity(World world, IBlockState state) {
        try {
            return this.getTileEntityClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract Class<? extends UpgradeableBlockTileEntity> getTileEntityClass();

    @Override
    public ItemStack getWailaStack(IBlockRegistration.IDataAccessor accessor) {
        return this.getItemStack();
    }

    @Override
    public final List<String> getWailaTooltip(List<String> currentTooltip, IBlockRegistration.IDataAccessor accessor) {
        TileEntity te = accessor.getTileEntity();
        EntityPlayer player = accessor.getPlayer();
        IBlockState blockState = accessor.getBlockState();
        UpgradeableBlockTileEntity ute = (UpgradeableBlockTileEntity)te;
        this.onWailaTooltipHeader(currentTooltip, blockState, ute, player);
        this.onWailaTooltipBody(currentTooltip, blockState, ute, player);
        this.onWailaTooltipFooter(currentTooltip, blockState, ute, player);
        return currentTooltip;
    }

    protected boolean shouldWailaTooltipShowAll(IBlockState blockState, TileEntityClass te) {
        return false;
    }

    private final void onWailaTooltipBody(List<String> currentTooltip, IBlockState blockState, TileEntityClass te, EntityPlayer player) {
        int moreSize;
        List<String> upgrades = this.onWailaTooltipShowUpgrades(te);
        List<String> more = this.onWailaTooltipMore(blockState, te, player);
        int n = moreSize = more == null ? 0 : more.size();
        if (player.func_70093_af() || upgrades.size() + moreSize < 2 || this.shouldWailaTooltipShowAll(blockState, te)) {
            currentTooltip.addAll(upgrades);
            if (more != null) {
                currentTooltip.addAll(more);
            }
        } else if (upgrades.size() + moreSize > 0) {
            if (moreSize > 0) {
                currentTooltip.add(Translation.localize("waila.soulus:upgradeable_block.show_more", new Object[0]));
            } else {
                currentTooltip.add(Translation.localize("waila.soulus:upgradeable_block.show_upgrades", new Object[0]));
            }
        }
    }

    private final List<String> onWailaTooltipShowUpgrades(TileEntityClass te) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (te != null && te instanceof UpgradeableBlockTileEntity) {
            this.onWailaTooltipUpgrades(tooltip, te);
        }
        return tooltip;
    }

    protected void onWailaTooltipUpgrades(List<String> currentTooltip, TileEntityClass te) {
        String tooltip;
        ArrayList<IUpgrade> upgrades = new ArrayList<IUpgrade>(Arrays.asList(this.getUpgrades()));
        for (IUpgrade upgrade : Lists.reverse(((UpgradeableBlockTileEntity)((Object)te)).insertionOrder)) {
            upgrades.remove(upgrade);
            tooltip = this.getWailaTooltipUpgrade(upgrade, te);
            if (tooltip == null) continue;
            currentTooltip.add(tooltip);
        }
        for (IUpgrade upgrade : upgrades) {
            tooltip = this.getWailaTooltipUpgrade(upgrade, te);
            if (tooltip == null) continue;
            currentTooltip.add(tooltip);
        }
    }

    @Nullable
    protected String getWailaTooltipUpgrade(IUpgrade upgrade, TileEntityClass te) {
        String upgradeName = upgrade.getName().toLowerCase();
        int upgradeCount = ((UpgradeableBlockTileEntity)((Object)te)).upgrades.get(upgrade);
        if (upgrade.isSecret() && upgradeCount == 0) {
            return null;
        }
        return Translation.localize("waila." + this.getRegistryName() + ".upgrades_" + upgradeName, upgradeCount, upgrade.getMaxQuantity());
    }

    @Nullable
    protected List<String> onWailaTooltipMore(IBlockState blockState, TileEntityClass te, EntityPlayer player) {
        return null;
    }

    protected void onWailaTooltipHeader(List<String> currentTooltip, IBlockState blockState, TileEntityClass te, EntityPlayer player) {
    }

    protected void onWailaTooltipFooter(List<String> currentTooltip, IBlockState blockState, TileEntityClass te, EntityPlayer player) {
    }

    public static interface IUpgrade {
        public int getIndex();

        public String getName();

        public ItemStack getItemStack(int var1);

        @Nullable
        default public ItemStack getItemStackForTileEntity(UpgradeableBlockTileEntity te, int quantity) {
            return this.getItemStack(quantity);
        }

        default public void addItemStackToList(List<ItemStack> list, int quantity) {
            this.addItemStackToList(null, list, quantity);
        }

        default public void addItemStackToList(UpgradeableBlockTileEntity te, List<ItemStack> list, int quantity) {
            ItemStack item;
            ItemStack itemStack = item = te == null ? this.getItemStack(1) : this.getItemStackForTileEntity(te, 1);
            if (item == null) {
                return;
            }
            int maxStackSize = item.func_77976_d();
            while (quantity > 0) {
                int stackSize = Math.min(maxStackSize, quantity);
                list.add(te == null ? this.getItemStack(stackSize) : this.getItemStackForTileEntity(te, stackSize));
                quantity -= maxStackSize;
            }
        }

        public boolean isItemStack(ItemStack var1);

        default public boolean isItemStackForTileEntity(ItemStack stack, UpgradeableBlockTileEntity te) {
            return this.isItemStack(stack);
        }

        public int getMaxQuantity();

        public void setMaxQuantity(int var1);

        default public boolean canOverrideMaxQuantity() {
            return true;
        }

        default public boolean isSecret() {
            return false;
        }
    }
}

