/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.soul_totem;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import yuudaari.soulus.common.block.soul_totem.SoulTotemTileEntity;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSoulTotem;
import yuudaari.soulus.common.item.SoulCatalyst;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.StructureMap;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class SoulTotem
extends UpgradeableBlock<SoulTotemTileEntity> {
    @ConfigInjected.Inject
    public static ConfigSoulTotem CONFIG;
    public static final PropertyBool CONNECTED;
    public StructureMap structure = new StructureMap();

    @Override
    public UpgradeableBlock.IUpgrade[] getUpgrades() {
        return Upgrade.values();
    }

    public SoulTotem() {
        super("soul_totem", new Material(MapColor.field_151649_A).setTransparent());
        StructureMap.BlockValidator niobium = StructureMap.BlockValidator.byBlock(BlockRegistry.BLOCK_NIOBIUM);
        this.structure.addBlock(-1, -1, -1, niobium);
        this.structure.addBlock(1, -1, -1, niobium);
        this.structure.addBlock(-1, -1, 1, niobium);
        this.structure.addBlock(1, -1, 1, niobium);
        this.setHasItem();
        this.func_149711_c(5.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149649_H();
        this.setHasDescription();
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public UpgradeableBlock<SoulTotemTileEntity> getInstance() {
        return BlockRegistry.SOUL_TOTEM;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        SoulTotemTileEntity te = (SoulTotemTileEntity)world.func_175625_s(pos);
        return te == null ? 0 : te.getSignalStrength();
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        SoulTotem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED)).booleanValue()) {
            SoulTotem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(-0.4375, -0.875, -0.4375, 1.4375, 0.25, 0.0));
            SoulTotem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(-0.4375, -0.875, 1.0, 1.4375, 0.25, 1.4375));
            SoulTotem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(-0.4375, -0.875, 0.0, 0.0, 0.25, 1.0));
            SoulTotem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(1.0, -0.875, 0.0, 1.4375, 0.25, 1.0));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED) != false ? 1 : 0;
    }

    @Override
    public boolean hasTileEntity(IBlockState blockState) {
        return true;
    }

    @Override
    public Class<? extends UpgradeableBlockTileEntity> getTileEntityClass() {
        return SoulTotemTileEntity.class;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        SoulTotemTileEntity te = (SoulTotemTileEntity)world.func_175625_s(pos);
        if (te == null) {
            return;
        }
        if (placer instanceof EntityPlayer) {
            te.setOwner((EntityPlayer)placer);
        }
    }

    @Override
    protected void onWailaTooltipHeader(List<String> currentTooltip, IBlockState blockState, SoulTotemTileEntity te, EntityPlayer player) {
        currentTooltip.add(Translation.localize("waila.soulus:soul_totem.fuel_percentage", (int)Math.ceil(te.getFuelPercent() * 100.0f)));
    }

    static {
        CONNECTED = PropertyBool.func_177716_a((String)"connected");
    }

    public static enum Upgrade implements UpgradeableBlock.IUpgrade
    {
        SOUL_CATALYST(0, "soul_catalyst", ItemRegistry.SOUL_CATALYST.getItemStack()),
        EFFICIENCY(1, "efficiency", ItemRegistry.GEAR_NIOBIUM.getItemStack());

        private final int index;
        private final String name;
        private final ItemStack stack;
        private Integer maxQuantity;

        private Upgrade(int index, String name, ItemStack item) {
            this.index = index;
            this.name = name;
            this.stack = item;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxQuantity() {
            if (this.maxQuantity == null) {
                if (this.name.equals("soul_catalyst")) {
                    return 1;
                }
                if (this.name.equals("efficiency")) {
                    return 16;
                }
            }
            return this.maxQuantity;
        }

        @Override
        public void setMaxQuantity(int quantity) {
            this.maxQuantity = quantity;
        }

        @Override
        public boolean isItemStack(ItemStack stack) {
            if (stack.func_77973_b() != this.stack.func_77973_b()) {
                return false;
            }
            if (this.name.equals("soul_catalyst")) {
                return SoulCatalyst.isFilled(stack);
            }
            return true;
        }

        @Override
        public ItemStack getItemStack(int quantity) {
            ItemStack stack = new ItemStack(this.stack.func_77973_b(), quantity);
            if (this.name.equals("soul_catalyst")) {
                SoulCatalyst.setFilled(stack);
            }
            return stack;
        }
    }
}

