/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.soul_inquirer;

import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.block.soul_inquirer.SoulInquirer;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSoulInquirer;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.registration.BlockRegistry;

@ConfigInjected(value="soulus")
public class SoulInquirerTileEntity
extends UpgradeableBlockTileEntity
implements ITickable {
    @ConfigInjected.Inject
    public static ConfigSoulInquirer CONFIG;
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG_ESSENCES;
    private boolean hasInit = false;
    private String essenceType;
    private int activatingRange;
    private int signalStrength;
    private double timeTillParticle = 0.0;
    public double mobRotation;
    public double prevMobRotation;
    public EntityLiving renderMob;
    public String lastRenderedEssenceType;
    private int soulInquiryResult = 0;
    private int timeTillNextMajorUpdate = 0;

    public SoulInquirer getBlock() {
        return BlockRegistry.SOUL_INQUIRER;
    }

    public void reset() {
        this.renderMob = null;
        this.blockUpdate();
    }

    private void onUpdateUpgrades() {
        this.onUpdateUpgrades(false);
    }

    @Override
    public void onUpdateUpgrades(boolean readFromNBT) {
        if (this.func_145837_r()) {
            Soulus.removeConfigReloadHandler(this::onUpdateUpgrades);
            return;
        }
        Soulus.onConfigReload(this::onUpdateUpgrades);
        int rangeUpgrades = (Integer)this.upgrades.get(SoulInquirer.Upgrade.RANGE);
        this.activatingRange = SoulInquirerTileEntity.CONFIG.nonUpgradedRange + rangeUpgrades * SoulInquirerTileEntity.CONFIG.upgradeRangeEffectiveness;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.blockUpdate();
        }
    }

    public String getEssenceType() {
        return this.essenceType;
    }

    public void setEssenceType(String essenceType) {
        this.essenceType = essenceType;
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }

    public NBTTagCompound getEntityNbt() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74778_a("id", this.getSpawnMob());
        result.func_74774_a("PersistenceRequired", (byte)1);
        return result;
    }

    private String getSpawnMob() {
        return this.essenceType;
    }

    public int soulInquiry() {
        return this.soulInquiryResult;
    }

    public void updateSoulInquiry() {
        this.soulInquiryResult = 0;
        if (this.field_145850_b.func_175687_A(this.field_174879_c) != 0) {
            return;
        }
        AxisAlignedBB activationBox = new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.activatingRange);
        for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, activationBox)) {
            ResourceLocation entityType;
            if (entity instanceof EntityPlayer || !(entityType = EntityList.func_191301_a((Entity)entity)).toString().equalsIgnoreCase(this.essenceType)) continue;
            ++this.soulInquiryResult;
        }
    }

    public void func_73660_a() {
        if (this.essenceType == null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)SoulInquirer.HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
            return;
        }
        if (!this.hasInit) {
            this.hasInit = true;
            this.onUpdateUpgrades(false);
        }
        if (this.timeTillNextMajorUpdate-- < 0) {
            this.timeTillNextMajorUpdate = 20;
            this.updateSoulInquiry();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateRenderer();
        } else {
            this.updateSignalStrength();
        }
    }

    private void updateSignalStrength() {
        int upgradeCount = (Integer)this.upgrades.get(SoulInquirer.Upgrade.COUNT);
        int signalStrength = upgradeCount == 0 ? (this.soulInquiryResult > 0 ? 15 : 0) : (int)(Math.min(15.0, (double)this.soulInquiryResult / ((double)upgradeCount * 16.0 - 1.0)) * 16.0);
        if (signalStrength != this.signalStrength) {
            this.signalStrength = signalStrength;
            this.func_70296_d();
        }
    }

    @Override
    public void onReadFromNBT(NBTTagCompound compound) {
        this.hasInit = true;
        this.essenceType = compound.func_74779_i("entity_type");
        this.onUpdateUpgrades(false);
    }

    @Override
    @Nonnull
    public void onWriteToNBT(NBTTagCompound compound) {
        if (this.essenceType == null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)SoulInquirer.HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
            return;
        }
        compound.func_74778_a("entity_type", this.essenceType);
    }

    private boolean isPlayerInRangeForEffects() {
        return this.field_145850_b.func_175636_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0);
    }

    private void updateRenderer() {
        int upgradeCount = (Integer)this.upgrades.get(SoulInquirer.Upgrade.COUNT);
        double rotationAmount = upgradeCount == 0 ? (this.soulInquiryResult > 0 ? 0.125 : 0.0) : Math.min(16.0, (double)this.soulInquiryResult / ((double)upgradeCount * 16.0 - 1.0)) / 8.0;
        double diff = this.mobRotation - this.prevMobRotation;
        this.prevMobRotation = this.mobRotation;
        this.mobRotation += this.soulInquiryResult == 0 ? diff * 0.9 : rotationAmount + diff * 0.8;
        if (this.isPlayerInRangeForEffects()) {
            double particleCount = SoulInquirerTileEntity.CONFIG.particleCount * (double)Math.min(1, this.soulInquiryResult) / 2.0;
            if (particleCount < 1.0) {
                this.timeTillParticle += 0.01 + particleCount;
                if (this.timeTillParticle < 1.0) {
                    return;
                }
            }
            this.timeTillParticle = 0.0;
            int i = 0;
            while ((double)i < particleCount) {
                double d3 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
                double d4 = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
                double d5 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
                this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, d3 - (double)this.field_174879_c.func_177958_n() - 0.5, -0.3, d5 - (double)this.field_174879_c.func_177952_p() - 0.5, new int[0]);
                ++i;
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177229_b((IProperty)SoulInquirer.HAS_SOULBOOK) != newState.func_177229_b((IProperty)SoulInquirer.HAS_SOULBOOK);
    }
}

