/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.soul_inquirer;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import yuudaari.soulus.common.block.soul_inquirer.SoulInquirerTileEntity;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.item.CrystalBlood;
import yuudaari.soulus.common.item.OrbMurky;
import yuudaari.soulus.common.item.Soulbook;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.IBlockRegistration;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.EssenceType;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class SoulInquirer
extends UpgradeableBlock<SoulInquirerTileEntity> {
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG_ESSENCES;
    public static final PropertyBool HAS_SOULBOOK;

    @Override
    public UpgradeableBlock.IUpgrade[] getUpgrades() {
        return Upgrade.values();
    }

    public SoulInquirer() {
        super("soul_inquirer", new Material(MapColor.field_151665_m).setTransparent());
        this.setHasItem();
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.func_149649_H();
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
        this.setHasDescription();
    }

    @Override
    public UpgradeableBlock<SoulInquirerTileEntity> getInstance() {
        return BlockRegistry.SOUL_INQUIRER;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        SoulInquirer.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0));
    }

    public boolean func_149740_M(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK);
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        SoulInquirerTileEntity te = (SoulInquirerTileEntity)world.func_175625_s(pos);
        return te == null ? 0 : te.getSignalStrength();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HAS_SOULBOOK});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK) != false ? 0 : 1;
    }

    @Override
    public Registration.ItemBlock createItemBlock() {
        return new Registration.ItemBlock(this){

            public String func_77653_i(ItemStack stack) {
                String essenceType = EssenceType.getEssenceType(stack);
                ConfigEssence config = CONFIG_ESSENCES.get(essenceType);
                if (essenceType == null || config == null) {
                    return Translation.localize(this.func_77658_a() + ".unfocused.name", new Object[0]).trim();
                }
                String alignment = config.name;
                if (alignment == null) {
                    alignment = Translation.localizeEntity(essenceType);
                }
                return Translation.localize(this.func_77658_a() + ".focused.name", alignment).trim();
            }
        };
    }

    public ItemStack getItemStack(SoulInquirerTileEntity te, int count, int metadata) {
        ItemStack itemStack = new ItemStack((Item)this.getItemBlock(), count, metadata);
        if (te != null) {
            itemStack.func_77982_d(te.func_189515_b(new NBTTagCompound()));
        }
        return itemStack;
    }

    @Override
    public boolean hasTileEntity(IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)HAS_SOULBOOK);
    }

    @Override
    public Class<? extends UpgradeableBlockTileEntity> getTileEntityClass() {
        return SoulInquirerTileEntity.class;
    }

    @Override
    public boolean onActivateEmptyHand(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK)).booleanValue()) {
            return false;
        }
        boolean returnedUpgrade = super.onActivateEmptyHand(world, pos, player);
        if (!returnedUpgrade) {
            SoulInquirerTileEntity te = (SoulInquirerTileEntity)world.func_175625_s(pos);
            SoulInquirer.returnItemsToPlayer(world, Collections.singletonList(Soulbook.getFilled(te.getEssenceType())), player);
            world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public void addOtherDropStacksToList(List<ItemStack> list, World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof SoulInquirerTileEntity) {
            SoulInquirerTileEntity ste = (SoulInquirerTileEntity)te;
            list.add(Soulbook.getFilled(ste.getEssenceType()));
        }
    }

    @Override
    public boolean onActivateEmptyHandSneaking(World world, BlockPos pos, EntityPlayer player) {
        super.onActivateEmptyHandSneaking(world, pos, player);
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
        return true;
    }

    @Override
    public boolean onActivateInsert(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        Item item = stack.func_77973_b();
        IBlockState state = world.func_180495_p(pos);
        if (item == ItemRegistry.SOULBOOK) {
            SoulInquirerTileEntity te;
            String oldEssenceType;
            if (!Soulbook.isFilled(stack)) {
                return false;
            }
            if (!((Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK)).booleanValue()) {
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(true)));
            }
            if ((oldEssenceType = (te = (SoulInquirerTileEntity)world.func_175625_s(pos)).getEssenceType()) != null) {
                SoulInquirer.returnItemsToPlayer(world, Collections.singletonList(Soulbook.getFilled(te.getEssenceType())), player);
            }
            String newEssenceType = EssenceType.getEssenceType(stack);
            te.setEssenceType(newEssenceType);
            te.reset();
            stack.func_190918_g(1);
            return true;
        }
        return super.onActivateInsert(world, pos, player, stack);
    }

    @Override
    protected void onWailaTooltipHeader(List<String> currentTooltip, IBlockState blockState, SoulInquirerTileEntity te, EntityPlayer player) {
        if (te == null) {
            return;
        }
        int upgradeCount = (Integer)te.upgrades.get(Upgrade.COUNT);
        if (upgradeCount == 0) {
            String detection = te.soulInquiry() > 0 ? "something" : "nothing";
            currentTooltip.add(Translation.localize("waila.soulus:soul_inquirer.detecting_" + detection, new Object[0]));
        } else {
            currentTooltip.add(new Translation("waila.soulus:soul_inquirer.detecting", new Object[0]).addArgs(Math.min(15, te.soulInquiry()), upgradeCount * 16 - 1).get(new Object[0]));
        }
    }

    @Override
    public ItemStack getWailaStack(IBlockRegistration.IDataAccessor accessor) {
        TileEntity te = accessor.getTileEntity();
        return this.getItemStack((SoulInquirerTileEntity)te, 1, 0);
    }

    static {
        HAS_SOULBOOK = PropertyBool.func_177716_a((String)"has_soulbook");
    }

    public static enum Upgrade implements UpgradeableBlock.IUpgrade
    {
        RANGE(0, "range", ItemRegistry.ORB_MURKY.getItemStack()),
        COUNT(1, "count", ItemRegistry.CRYSTAL_BLOOD.getItemStack());

        private final int index;
        private final String name;
        private final ItemStack stack;
        private int maxQuantity = 16;

        private Upgrade(int index, String name, ItemStack item) {
            this.index = index;
            this.name = name;
            this.stack = item;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxQuantity() {
            return this.maxQuantity;
        }

        @Override
        public void setMaxQuantity(int quantity) {
            this.maxQuantity = quantity;
        }

        @Override
        public boolean isItemStack(ItemStack stack) {
            if (stack.func_77973_b() != this.stack.func_77973_b()) {
                return false;
            }
            if (this.name == "count") {
                return CrystalBlood.isFilled(stack);
            }
            if (this.name == "range") {
                return OrbMurky.isFilled(stack);
            }
            return true;
        }

        @Override
        public ItemStack getItemStack(int quantity) {
            ItemStack stack = new ItemStack(this.stack.func_77973_b(), quantity);
            if (this.name == "count") {
                CrystalBlood.setFilled(stack);
            } else if (this.name == "range") {
                OrbMurky.setFilled(stack);
            }
            return stack;
        }
    }
}

