/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scala.Tuple2;
import yuudaari.soulus.common.CreativeTab;
import yuudaari.soulus.common.block.enderlink.Enderlink;
import yuudaari.soulus.common.block.enderlink.EnderlinkTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigEnderlink;
import yuudaari.soulus.common.registration.IBlockRegistration;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class DustEnderBlock
extends Registration.Block {
    @ConfigInjected.Inject
    public static ConfigEnderlink CONFIG;
    public static final PropertyEnum<EnumDyeColor> COLOR;

    @SubscribeEvent
    public static final void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_77973_b() == Items.field_151100_aR && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof DustEnderBlock) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public DustEnderBlock() {
        super("dust_ender_block", Material.field_151594_q);
        this.func_180632_j(this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.LIGHT_BLUE));
        this.addOreDict(new String[]{"dustEnder", "bonemeal"});
        this.func_149672_a(SoundType.field_185851_d);
    }

    public CreativeTab getCreativeTabToDisplayOn() {
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() != Items.field_151100_aR) {
            return false;
        }
        EnumDyeColor newColor = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
        if (state.func_177229_b(COLOR) == newColor) {
            return false;
        }
        world.func_180501_a(pos, state.func_177226_a(COLOR, (Comparable)newColor), 3);
        stack.func_190918_g(1);
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if ((double)world.field_73012_v.nextFloat() > DustEnderBlock.CONFIG.teleportChance) {
            return;
        }
        if (!entity.func_174813_aQ().func_72326_a(this.func_185496_a(state, (IBlockAccess)world, pos).func_186670_a(pos))) {
            return;
        }
        ArrayList<Tuple2> links = new ArrayList<Tuple2>();
        EnumDyeColor color = (EnumDyeColor)world.func_180495_p(pos).func_177229_b(COLOR);
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                int cx = (pos.func_177958_n() >> 4) + x;
                int cz = (pos.func_177952_p() >> 4) + z;
                for (BlockPos enderlinkPos : Enderlink.getEnderlinksInChunk(cx, cz)) {
                    double distance;
                    EnderlinkTileEntity ete2 = (EnderlinkTileEntity)world.func_175625_s(enderlinkPos);
                    if (ete2.color != color || world.func_175687_A(ete2.func_174877_v()) > 0 || !ete2.isWithinRange(entity, distance = entity.func_174831_c(ete2.func_174877_v()))) continue;
                    links.add(new Tuple2((Object)ete2, (Object)distance));
                }
            }
        }
        links.stream().sorted((a, b) -> Double.compare((Double)a._2, (Double)b._2)).filter(ete -> ((EnderlinkTileEntity)((Object)((Object)ete._1))).teleportEntity(entity)).findFirst();
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.BONEMEAL_ENDER;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemRegistry.BONEMEAL_ENDER.getItemStack();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    @Override
    public final List<String> getWailaTooltip(List<String> currentTooltip, IBlockRegistration.IDataAccessor accessor) {
        String color = ((EnumDyeColor)accessor.getBlockState().func_177229_b(COLOR)).func_192396_c();
        currentTooltip.add(Translation.localize("waila.soulus:misc.color." + color, new Object[0]));
        return currentTooltip;
    }

    static {
        COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    }
}

