/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.advancement;

import com.google.common.base.Optional;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import yuudaari.soulus.common.advancement.BasicTrigger;
import yuudaari.soulus.common.advancement.MatchableCriterionInstance;

public class BreakBlockTrigger
extends BasicTrigger<Instance, IBlockState> {
    private static final ResourceLocation ID = new ResourceLocation("soulus", "break_block");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    @Override
    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        Block block = null;
        if (json.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"block"));
            if (!Block.field_149771_c.func_148741_d((Object)resourcelocation)) {
                throw new JsonSyntaxException("Unknown block type '" + resourcelocation + "'");
            }
            block = (Block)Block.field_149771_c.func_82594_a((Object)resourcelocation);
        }
        HashMap<IProperty, Object> map = null;
        if (json.has("state")) {
            if (block == null) {
                throw new JsonSyntaxException("Can't define block state without a specific block type");
            }
            BlockStateContainer blockstatecontainer = block.func_176194_O();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"state").entrySet()) {
                IProperty iproperty = blockstatecontainer.func_185920_a((String)entry.getKey());
                if (iproperty == null) {
                    throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                }
                String s = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                Optional optional = iproperty.func_185929_b(s);
                if (!optional.isPresent()) {
                    throw new JsonSyntaxException("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "' on block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                }
                if (map == null) {
                    map = new HashMap<IProperty, Object>();
                }
                map.put(iproperty, optional.get());
            }
        }
        return new Instance(block, map);
    }

    public static class Instance
    extends MatchableCriterionInstance<IBlockState> {
        private final Block block;
        private final Map<IProperty<?>, Object> properties;

        public Instance(@Nullable Block blockIn, @Nullable Map<IProperty<?>, Object> propertiesIn) {
            super(ID);
            this.block = blockIn;
            this.properties = propertiesIn;
        }

        @Override
        public boolean matches(EntityPlayerMP player, IBlockState state) {
            if (this.block != null && state.func_177230_c() != this.block) {
                return false;
            }
            if (this.properties == null) {
                return true;
            }
            for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
                if (state.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
            return true;
        }
    }
}

