/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.helper;

import com.mojang.authlib.GameProfile;
import com.rwtema.funkylocomotion.api.FunkyCapabilities;
import com.rwtema.funkylocomotion.api.IMoveCheck;
import com.rwtema.funkylocomotion.api.ISlipperyBlock;
import com.rwtema.funkylocomotion.helper.MethodHandleUtils;
import com.rwtema.funkylocomotion.movepermissions.MoveCheckReflector;
import com.rwtema.funkylocomotion.proxydelegates.ProxyRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BlockHelper {
    private static final MethodHandle methodHandle_Chunk_relightBlock = MethodHandleUtils.getMethodHandleVirtual(Chunk.class, new String[]{"func_76615_h", "relightBlock"}, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodHandle methodHandle_Chunk_propagateSkylightOcclusion = MethodHandleUtils.getMethodHandleVirtual(Chunk.class, new String[]{"func_76595_e", "propagateSkylightOcclusion"}, Integer.TYPE, Integer.TYPE);
    private static final Field field_Chunk_precipitationHeightMap = ReflectionHelper.findField(Chunk.class, (String[])new String[]{"field_76638_b", "precipitationHeightMap"});

    public static boolean silentSetBlock(Chunk chunk, BlockPos pos, Block block, int meta) {
        int dx = pos.func_177958_n() & 0xF;
        int dz = pos.func_177952_p() & 0xF;
        int y = pos.func_177956_o();
        int i1 = dz << 4 | dx;
        try {
            int[] precMap = (int[])field_Chunk_precipitationHeightMap.get(chunk);
            if (y >= precMap[i1] - 1) {
                precMap[i1] = -999;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        IBlockState state1 = chunk.func_186032_a(dx, y, dz);
        Block block1 = state1.func_177230_c();
        int k1 = block1.func_176201_c(state1);
        if (block1 == block && k1 == meta) {
            return false;
        }
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !chunk.func_177412_p().field_73011_w.func_177495_o());
            chunk.func_76587_i()[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
        }
        extendedblockstorage.func_177484_a(dx, y & 0xF, dz, block.func_176203_a(meta));
        chunk.func_177427_f(true);
        return true;
    }

    public static void silentClear(Chunk chunk, BlockPos pos) {
        BlockHelper.silentSetBlock(chunk, pos, Blocks.field_150350_a, 0);
    }

    public static void postUpdateBlock(World world, BlockPos pos) {
        int i1 = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        Chunk chunk = world.func_175726_f(pos);
        try {
            int[] precMap = (int[])field_Chunk_precipitationHeightMap.get(chunk);
            if (pos.func_177956_o() >= precMap[i1] - 1) {
                precMap[i1] = -999;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        int j1 = chunk.func_177445_q()[i1];
        boolean flag = pos.func_177956_o() >= j1;
        IBlockState newState = chunk.func_186032_a(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
        Block newBlock = newState.func_177230_c();
        int k2 = 255;
        if (flag) {
            chunk.func_76603_b();
        } else {
            int j2 = newBlock.getLightOpacity(newState, (IBlockAccess)world, pos);
            try {
                if (j2 > 0) {
                    if (pos.func_177956_o() >= j1) {
                        methodHandle_Chunk_relightBlock.invokeExact(chunk, pos.func_177958_n() & 0xF, pos.func_177956_o() + 1, pos.func_177952_p() & 0xF);
                    }
                } else if (pos.func_177956_o() == j1 - 1) {
                    methodHandle_Chunk_relightBlock.invokeExact(chunk, pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
                }
                if (j2 != k2 && (j2 < k2 || chunk.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                    methodHandle_Chunk_propagateSkylightOcclusion.invokeExact(chunk, pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        world.func_175664_x(pos);
        BlockHelper.markBlockForUpdate(world, pos);
        if (!world.field_72995_K) {
            world.func_190524_a(pos, Blocks.field_150350_a, pos);
            world.func_190524_a(pos, newBlock, pos);
            world.func_175685_c(pos, newBlock, false);
            if (newState.func_185912_n()) {
                world.func_175666_e(pos, newBlock);
            }
        }
    }

    public static boolean canMoveBlock(World world, BlockPos pos, @Nullable GameProfile profile) {
        EnumActionResult result;
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b == Blocks.field_150350_a || b.isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        IMoveCheck check = ProxyRegistry.getInterface(b, IMoveCheck.class, FunkyCapabilities.MOVE_CHECK);
        if (check != null && (result = check.canMove(world, pos, profile)) != EnumActionResult.PASS) {
            return result == EnumActionResult.SUCCESS;
        }
        if (state.func_185887_b(world, pos) < 0.0f) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            check = ProxyRegistry.getInterface(tile, IMoveCheck.class, FunkyCapabilities.MOVE_CHECK);
            if (check != null) {
                EnumActionResult result2 = check.canMove(world, pos, profile);
                if (result2 != EnumActionResult.PASS) {
                    return result2 == EnumActionResult.SUCCESS;
                }
            } else {
                EnumActionResult result3 = MoveCheckReflector.canMoveClass(tile.getClass(), world, pos, profile);
                if (result3 != EnumActionResult.PASS) {
                    return result3 == EnumActionResult.SUCCESS;
                }
            }
        }
        return MoveCheckReflector.canMoveClass(b.getClass());
    }

    public static void breakBlockWithDrop(World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_185904_a().func_76224_d()) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        } else {
            world.func_175655_b(pos, true);
        }
    }

    public static boolean isValid(World world, BlockPos pos) {
        return world.func_175667_e(pos);
    }

    public static boolean canStick(World world, BlockPos pos, EnumFacing dir, @Nullable GameProfile profile) {
        if (!BlockHelper.isValid(world, pos)) {
            return false;
        }
        if (!BlockHelper.canMoveBlock(world, pos, profile)) {
            return false;
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        ISlipperyBlock slip = ProxyRegistry.getInterface(b, ISlipperyBlock.class, FunkyCapabilities.SLIPPERY_BLOCK);
        return slip == null || slip.canStickTo(world, pos, dir);
    }

    public static boolean canReplace(World world, BlockPos pos) {
        return BlockHelper.isValid(world, pos) && (world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos));
    }

    public static TileEntity getTile(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public static void markBlockForUpdate(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 0);
    }

    @Nullable
    public static <T extends TileEntity> T getTileEntitySafely(IBlockAccess world, BlockPos pos, Class<T> tileClass) {
        TileEntity te;
        if (world instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)world;
            te = chunkCache.func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        } else {
            te = world.func_175625_s(pos);
        }
        if (tileClass.isInstance(te)) {
            return (T)((TileEntity)tileClass.cast(te));
        }
        return null;
    }
}

