/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.google.common.collect.Streams;
import com.rwtema.funkylocomotion.blocks.BlockFLMultiState;
import com.rwtema.funkylocomotion.blocks.BlockMassFrameEdge;
import com.rwtema.funkylocomotion.blocks.FLBlocks;
import com.rwtema.funkylocomotion.blocks.TileMassFrame;
import com.rwtema.funkylocomotion.blocks.TileMassFrameController;
import com.rwtema.funkylocomotion.helper.NullHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMassFrameCorner
extends BlockFLMultiState {
    private static final double s = 0.125;
    private static final boolean[] booleanValues = new boolean[]{false, true};
    public static Map<EnumFacing, PropertyBool> PROPERTY_MAP = Stream.of(EnumFacing.values()).collect(Collectors.toMap(s -> s, s -> PropertyBool.func_177716_a((String)s.func_176742_j())));
    public static PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static PropertyEnum<State> STATE = PropertyEnum.func_177709_a((String)"state", State.class);
    AxisAlignedBB bounds = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);

    public BlockMassFrameCorner() {
        super(Material.field_151576_e);
        this.setRegistryName("funkylocomotion:mass_frame_corner");
        this.func_149663_c("funkylocomotion:mass_frame_corner");
    }

    public static boolean checkEdgeFrame(World worldIn, @Nullable EntityPlayer playerIn, int x0, int y0, int z0, int x1, int y1, int z1) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        BlockMassFrameCorner blockMassFrameCorner = NullHelper.notNull(FLBlocks.MASS_FRAME_CORNER);
        for (boolean x : booleanValues) {
            for (boolean y : booleanValues) {
                for (boolean z : booleanValues) {
                    blockPos.func_181079_c(x ? x1 : x0, y ? y1 : y0, z ? z1 : z0);
                    IBlockState blockState = worldIn.func_180495_p((BlockPos)blockPos);
                    if (blockState.func_177230_c() == blockMassFrameCorner) continue;
                    if (playerIn != null) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.nocornerfound", new Object[]{blockMassFrameCorner.getBlockPosText((BlockPos)blockPos)}));
                    }
                    return false;
                }
            }
        }
        Block edgeBlock = NullHelper.notNull(FLBlocks.MASS_FRAME_EDGE);
        for (boolean x : booleanValues) {
            for (boolean y : booleanValues) {
                for (int z = z0 + 1; z <= z1 - 1; ++z) {
                    blockPos.func_181079_c(x ? x1 : x0, y ? y1 : y0, z);
                    if (worldIn.func_180495_p((BlockPos)blockPos).func_177230_c() == edgeBlock) continue;
                    if (playerIn != null) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.noedgefound", new Object[]{blockMassFrameCorner.getBlockPosText((BlockPos)blockPos)}));
                    }
                    return false;
                }
            }
        }
        for (boolean x : booleanValues) {
            for (boolean z : booleanValues) {
                for (int y = y0 + 1; y <= y1 - 1; ++y) {
                    blockPos.func_181079_c(x ? x1 : x0, y, z ? z1 : z0);
                    if (worldIn.func_180495_p((BlockPos)blockPos).func_177230_c() == edgeBlock) continue;
                    if (playerIn != null) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.noedgefound", new Object[]{blockMassFrameCorner.getBlockPosText((BlockPos)blockPos)}));
                    }
                    return false;
                }
            }
        }
        for (boolean z : booleanValues) {
            for (boolean y : booleanValues) {
                for (int x = x0 + 1; x <= x1 - 1; ++x) {
                    blockPos.func_181079_c(x, y ? y1 : y0, z ? z1 : z0);
                    if (worldIn.func_180495_p((BlockPos)blockPos).func_177230_c() == edgeBlock) continue;
                    if (playerIn != null) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.noedgefound", new Object[]{blockMassFrameCorner.getBlockPosText((BlockPos)blockPos)}));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        this.processPosition(worldIn, pos, playerIn);
        return true;
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounds;
    }

    public void processPosition(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        int z1;
        int y1;
        int x1;
        int z0;
        int y0;
        BlockMassFrameEdge edgeBlock = NullHelper.notNull(FLBlocks.MASS_FRAME_EDGE);
        HashMap<EnumFacing.Axis, BlockPos.MutableBlockPos> boundTypes = new HashMap<EnumFacing.Axis, BlockPos.MutableBlockPos>();
        block0: for (EnumFacing enumFacing : EnumFacing.values()) {
            Block block;
            if (boundTypes.get(enumFacing.func_176740_k()) != null && (block = worldIn.func_180495_p(pos.func_177972_a(enumFacing)).func_177230_c()) == edgeBlock) {
                if (playerIn != null) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.axis", new Object[]{enumFacing.func_176740_k().func_176719_a()}));
                }
                return;
            }
            BlockPos.MutableBlockPos npos = new BlockPos.MutableBlockPos(pos);
            for (int i = 0; i < 64; ++i) {
                npos.func_189536_c(enumFacing);
                Block block2 = worldIn.func_180495_p((BlockPos)npos).func_177230_c();
                if (block2 == edgeBlock) continue;
                if (block2 == this) {
                    if (i == 0) continue block0;
                    boundTypes.put(enumFacing.func_176740_k(), npos);
                    continue block0;
                }
                if (i == 0) continue block0;
                if (playerIn != null) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.nomatchingcorner", new Object[]{this.getBlockPosText((BlockPos)npos)}));
                }
                return;
            }
            if (playerIn != null) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.toolong", new Object[]{this.getFacingTranslation(enumFacing), 64}));
            }
            return;
        }
        if (boundTypes.size() != 3) {
            if (playerIn != null) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.err.corner", new Object[0]));
            }
            return;
        }
        int x0 = boundTypes.values().stream().mapToInt(Vec3i::func_177958_n).min().orElseThrow(RuntimeException::new);
        if (!BlockMassFrameCorner.checkEdgeFrame(worldIn, playerIn, x0, y0 = boundTypes.values().stream().mapToInt(Vec3i::func_177956_o).min().orElseThrow(RuntimeException::new), z0 = boundTypes.values().stream().mapToInt(Vec3i::func_177952_p).min().orElseThrow(RuntimeException::new), x1 = boundTypes.values().stream().mapToInt(Vec3i::func_177958_n).max().orElseThrow(RuntimeException::new), y1 = boundTypes.values().stream().mapToInt(Vec3i::func_177956_o).max().orElseThrow(RuntimeException::new), z1 = boundTypes.values().stream().mapToInt(Vec3i::func_177952_p).max().orElseThrow(RuntimeException::new))) {
            return;
        }
        TileMassFrameController controller = null;
        ArrayList<TileMassFrame> slaves = new ArrayList<TileMassFrame>();
        for (boolean x : booleanValues) {
            for (boolean y : booleanValues) {
                for (boolean z : booleanValues) {
                    BlockPos blockPos = new BlockPos(x ? x1 : x0, y ? y1 : y0, z ? z1 : z0);
                    if (x && y && z) {
                        worldIn.func_175656_a(blockPos, this.func_176223_P().func_177226_a(STATE, (Comparable)((Object)State.CONTROLLER)));
                        controller = (TileMassFrameController)worldIn.func_175625_s(blockPos);
                        continue;
                    }
                    worldIn.func_175656_a(blockPos, this.func_176223_P().func_177226_a(STATE, (Comparable)((Object)State.SLAVE)));
                    slaves.add((TileMassFrame)worldIn.func_175625_s(blockPos));
                }
            }
        }
        if (controller == null) {
            throw new RuntimeException();
        }
        Object object = slaves.iterator();
        while (object.hasNext()) {
            TileMassFrame slave = (TileMassFrame)object.next();
            slave.controllerPos = controller.func_174877_v().func_177973_b((Vec3i)slave.func_174877_v());
        }
        controller.start = new BlockPos(x0, y0, z0).func_177973_b((Vec3i)controller.func_174877_v());
        controller.end = new BlockPos(x1, y1, z1).func_177973_b((Vec3i)controller.func_174877_v());
        if (playerIn != null) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.mass.success", new Object[]{1 + x1 - x0, 1 + y1 - y0, 1 + z1 - z0}));
        }
    }

    @Nonnull
    private String getBlockPosText(BlockPos blockPos) {
        return "[" + blockPos.func_177958_n() + "," + blockPos.func_177956_o() + "," + blockPos.func_177952_p() + "]";
    }

    @Nonnull
    private TextComponentTranslation getFacingTranslation(EnumFacing enumFacing) {
        return new TextComponentTranslation("frame.dir.name." + enumFacing.ordinal(), new Object[0]);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])Streams.concat((Stream[])new Stream[]{Stream.of(STATE), Stream.of(ACTIVE), PROPERTY_MAP.values().stream()}).toArray(IProperty[]::new));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.values()) {
            state = state.func_177226_a((IProperty)PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == NullHelper.notNull(FLBlocks.MASS_FRAME_EDGE)));
        }
        state = state.func_177229_b(STATE) == State.EMPTY ? state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)) : state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true));
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((State)((Object)state.func_177229_b(STATE))).ordinal();
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(STATE, (Comparable)((Object)State.values()[meta % 3]));
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(STATE) != State.EMPTY;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch ((State)((Object)state.func_177229_b(STATE))) {
            case SLAVE: {
                return new TileMassFrame();
            }
            case CONTROLLER: {
                return new TileMassFrameController();
            }
        }
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static enum State implements IStringSerializable
    {
        EMPTY,
        SLAVE,
        CONTROLLER;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

