/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol.api;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.StringUtils;

public class IslandPos {
    private int posX;
    private int posY;
    private String type;
    private ArrayList<String> playerUUIDs;

    public IslandPos(int x, int y, UUID ... ids) {
        this.posX = x;
        this.posY = y;
        if (this.playerUUIDs == null) {
            this.playerUUIDs = new ArrayList();
        }
        for (UUID id : ids) {
            this.playerUUIDs.add(id.toString());
        }
    }

    public IslandPos(String type, int x, int y, UUID ... ids) {
        this.type = type;
        this.posX = x;
        this.posY = y;
        if (this.playerUUIDs == null) {
            this.playerUUIDs = new ArrayList();
        }
        for (UUID id : ids) {
            this.playerUUIDs.add(id.toString());
        }
    }

    public void addNewPlayer(UUID playerUUID) {
        if (!this.playerUUIDs.contains(playerUUID.toString())) {
            this.playerUUIDs.add(playerUUID.toString());
        }
    }

    public void removePlayer(UUID playerUUID) {
        if (this.playerUUIDs.contains(playerUUID.toString())) {
            this.playerUUIDs.remove(playerUUID.toString());
        }
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getPlayerUUIDs() {
        return this.playerUUIDs;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("posX", this.posX);
        nbt.func_74768_a("posY", this.posY);
        if (!StringUtils.isEmpty((CharSequence)this.type)) {
            nbt.func_74778_a("type", this.type);
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.playerUUIDs.size(); ++i) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74778_a("playerUUID", this.playerUUIDs.get(i));
            list.func_74742_a((NBTBase)stackTag);
        }
        nbt.func_74782_a("UUIDs", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.posX = nbt.func_74762_e("posX");
        this.posY = nbt.func_74762_e("posY");
        this.type = nbt.func_74779_i("type");
        this.playerUUIDs = new ArrayList();
        NBTTagList list = nbt.func_150295_c("UUIDs", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            String name = stackTag.func_74779_i("playerUUID");
            this.playerUUIDs.add(name);
        }
    }
}

