/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol;

import com.bartz24.voidislandcontrol.PlatformCommand;
import com.bartz24.voidislandcontrol.VoidIslandControlSaveData;
import com.bartz24.voidislandcontrol.api.IslandManager;
import com.bartz24.voidislandcontrol.api.IslandPos;
import com.bartz24.voidislandcontrol.config.ConfigOptions;
import com.bartz24.voidislandcontrol.world.WorldTypeVoid;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class EventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOpenGui(GuiOpenEvent e) {
        if (e.getGui() instanceof GuiCreateWorld && Minecraft.func_71410_x().field_71462_r instanceof GuiWorldSelection) {
            GuiCreateWorld cw = (GuiCreateWorld)e.getGui();
            ReflectionHelper.setPrivateValue(GuiCreateWorld.class, (Object)cw, (Object)this.getType(), (String[])new String[]{"field_146331_K", "selectedIndex"});
        }
    }

    private int getType() {
        for (int i = 0; i < WorldType.field_77139_a.length; ++i) {
            if (!(WorldType.field_77139_a[i] instanceof WorldTypeVoid)) continue;
            return i;
        }
        return 0;
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player;
        if (!(event.player.func_130014_f_().field_72995_K || !((player = event.player).func_130014_f_().func_72912_H().func_76067_t() instanceof WorldTypeVoid) || player.field_71093_bK != ConfigOptions.worldGenSettings.baseDimension || IslandManager.spawnedPlayers.size() != 0 && IslandManager.hasPlayerSpawned(player.func_146103_bH().getId()))) {
            boolean autoCreate;
            World world = player.func_130014_f_();
            BlockPos spawn = new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0);
            if (IslandManager.CurrentIslandsList.size() == 0) {
                IslandManager.CurrentIslandsList.add(new IslandPos(0, 0, new UUID[0]));
                BlockPos pos = spawn.func_177971_a((Vec3i)IslandManager.getSpawnOffset(IslandManager.CurrentIslandsList.get(0)));
                world.func_175652_B(pos);
                EventHandler.createSpawn(player, player.func_130014_f_(), spawn);
            }
            IslandManager.tpPlayerToPos(player, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0), IslandManager.CurrentIslandsList.get(0));
            boolean bl = autoCreate = ConfigOptions.islandSettings.autoCreate || player.func_184102_h().func_71262_S() && ConfigOptions.islandSettings.autoCreateServersOnly;
            if (autoCreate && !IslandManager.worldOneChunk) {
                if (player instanceof EntityPlayerMP) {
                    try {
                        PlatformCommand.newPlatform((EntityPlayerMP)player, new String[]{"create", "bypass"});
                    }
                    catch (CommandException e) {
                        player.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                    }
                }
            } else {
                if (ConfigOptions.islandSettings.oneChunk) {
                    WorldBorder border = player.func_130014_f_().func_73046_m().field_71305_c[0].func_175723_af();
                    border.func_177739_c(0.0, 0.0);
                    border.func_177750_a(16.0);
                    border.func_177747_c(1);
                    IslandManager.worldOneChunk = true;
                }
                EventHandler.spawnPlayer(player, spawn, false);
                player.func_70066_B();
            }
            IslandManager.spawnedPlayers.add(player.func_146103_bH().getId().toString());
        }
    }

    @SubscribeEvent
    public void playerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntity().func_130014_f_().field_72995_K) {
            int time;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.func_130014_f_().func_72912_H().func_76067_t() instanceof WorldTypeVoid && IslandManager.hasVisitLoc(player) && player.field_71093_bK == ConfigOptions.worldGenSettings.baseDimension && !player.func_184812_l_()) {
                if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71134_c.func_73081_b() != GameType.SPECTATOR) {
                    player.func_71033_a(GameType.SPECTATOR);
                }
                int posX = IslandManager.getVisitLoc(player).getX() * ConfigOptions.islandSettings.islandDistance;
                int posY = IslandManager.getVisitLoc(player).getY() * ConfigOptions.islandSettings.islandDistance;
                if (ConfigOptions.islandSettings.islandProtection && (Math.abs(player.field_70165_t - (double)posX) > (double)ConfigOptions.islandSettings.protectionBuildRange || Math.abs(player.field_70161_v - (double)posY) > (double)ConfigOptions.islandSettings.protectionBuildRange)) {
                    if (player.field_70173_aa % 60 == 0) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't be visiting that far away!"));
                    }
                    player.func_71033_a(GameType.SURVIVAL);
                    IslandManager.removeVisitLoc(player);
                    IslandManager.tpPlayerToPos(player, new BlockPos(posX, ConfigOptions.islandSettings.islandYLevel, posY), IslandManager.getVisitLoc(player));
                }
            }
            if (player.func_130014_f_().func_72912_H().func_76067_t() instanceof WorldTypeVoid && player.field_71093_bK == ConfigOptions.worldGenSettings.baseDimension && !player.func_184812_l_() && !IslandManager.hasVisitLoc(player) && player.func_184102_h().func_71262_S() && ConfigOptions.islandSettings.islandProtection && (Math.abs(player.field_70165_t) > (double)ConfigOptions.islandSettings.protectionBuildRange || Math.abs(player.field_70161_v) > (double)ConfigOptions.islandSettings.protectionBuildRange)) {
                int posY;
                IslandPos pos = IslandManager.getPlayerIsland(player.func_146103_bH().getId());
                int posX = pos == null ? 0 : pos.getX() * ConfigOptions.islandSettings.islandDistance;
                int n = posY = pos == null ? 0 : pos.getY() * ConfigOptions.islandSettings.islandDistance;
                if (ConfigOptions.islandSettings.islandProtection && (Math.abs(player.field_70165_t - (double)posX) > (double)ConfigOptions.islandSettings.protectionBuildRange || Math.abs(player.field_70161_v - (double)posY) > (double)ConfigOptions.islandSettings.protectionBuildRange)) {
                    if (player.field_70173_aa % 60 == 0) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't be away from your island or spawn that far away!"));
                    }
                    player.func_71033_a(GameType.SURVIVAL);
                    IslandManager.tpPlayerToPos(player, new BlockPos(posX, ConfigOptions.islandSettings.islandYLevel, posY), pos);
                }
            }
            ArrayList removeAt = new ArrayList();
            if (IslandManager.hasJoinLoc(player)) {
                time = IslandManager.getJoinTime(player);
                if (time > 0) {
                    IslandManager.setJoinTime(player, time - 1);
                } else {
                    IslandManager.removeJoinLoc(player);
                }
            }
            if (IslandManager.hasLeaveConfirm(player)) {
                time = IslandManager.getLeaveTime(player);
                if (time > 0) {
                    IslandManager.setLeaveTime(player, time - 1);
                } else {
                    IslandManager.removeLeaveConfirm(player);
                }
            }
            EventHandler.loadWorld(player);
        }
    }

    private static void loadWorld(EntityPlayer player) {
        if (!IslandManager.worldLoaded) {
            for (String s : ConfigOptions.commandSettings.worldLoadCommands) {
                if (StringUtils.isBlank((CharSequence)s)) continue;
                player.func_130014_f_().func_73046_m().func_71187_D().func_71556_a((ICommandSender)new EntityCow(player.func_130014_f_()){

                    public boolean func_70003_b(int permLevel, String commandName) {
                        return true;
                    }
                }, s);
            }
        }
        IslandManager.worldLoaded = true;
    }

    public static void spawnPlayer(EntityPlayer player, BlockPos pos, boolean spawnPlat) {
        if (spawnPlat) {
            EventHandler.createSpawn(player, player.func_130014_f_(), pos);
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP pmp = (EntityPlayerMP)player;
            IslandManager.tpPlayerToPosSpawn(player, pos, IslandManager.getPlayerIsland(pmp.func_110124_au()));
            IslandManager.setStartingInv(pmp);
        }
    }

    public static void spawnPlayer(EntityPlayer player, BlockPos pos, int forceType) {
        EventHandler.spawnPlat(player, player.func_130014_f_(), pos, forceType);
        EventHandler.spawnPlayer(player, pos, false);
    }

    public static void createSpawn(EntityPlayer player, World world, BlockPos spawn) {
        if (spawn.func_177958_n() == 0 && spawn.func_177952_p() == 0 && !IslandManager.worldOneChunk) {
            if (ConfigOptions.islandSettings.islandMainSpawnType.equals("bedrock")) {
                EventHandler.mainSpawn(world, spawn);
            } else {
                Random random = world.field_73012_v;
                int type = ConfigOptions.islandSettings.islandMainSpawnType.equals("random") ? random.nextInt(IslandManager.IslandGenerations.size()) : IslandManager.getIndexOfIslandType(ConfigOptions.islandSettings.islandMainSpawnType);
                EventHandler.spawnPlat(null, world, spawn, type);
            }
            return;
        }
        Random random = world.field_73012_v;
        int type = ConfigOptions.islandSettings.islandSpawnType.equals("random") ? random.nextInt(IslandManager.IslandGenerations.size()) : IslandManager.getIndexOfIslandType(ConfigOptions.islandSettings.islandSpawnType);
        EventHandler.spawnPlat(player, world, spawn, type);
    }

    private static void spawnPlat(@Nullable EntityPlayer player, World world, BlockPos spawn, int type) {
        if (player != null) {
            IslandPos position = IslandManager.getNextIsland();
            IslandManager.CurrentIslandsList.add(new IslandPos(IslandManager.IslandGenerations.get((int)type).Identifier, position.getX(), position.getY(), player.func_146103_bH().getId()));
        }
        IslandManager.IslandGenerations.get(type).generate(world, spawn);
        if (ConfigOptions.commandSettings.commandBlockType != ConfigOptions.CommandSettings.CommandBlockType.NONE) {
            Block cmdBlock = null;
            if (ConfigOptions.commandSettings.commandBlockType == ConfigOptions.CommandSettings.CommandBlockType.IMPULSE) {
                cmdBlock = Blocks.field_150483_bI;
            } else if (ConfigOptions.commandSettings.commandBlockType == ConfigOptions.CommandSettings.CommandBlockType.CHAIN) {
                cmdBlock = Blocks.field_185777_dd;
            } else if (ConfigOptions.commandSettings.commandBlockType == ConfigOptions.CommandSettings.CommandBlockType.REPEATING) {
                cmdBlock = Blocks.field_185776_dc;
            }
            if (cmdBlock != null) {
                world.func_180501_a(spawn.func_177979_c(3).func_177982_a(ConfigOptions.commandSettings.commandBlockPos.x, ConfigOptions.commandSettings.commandBlockPos.y, ConfigOptions.commandSettings.commandBlockPos.z), cmdBlock.func_176223_P().func_177226_a((IProperty)BlockCommandBlock.field_185564_a, (Comparable)ConfigOptions.commandSettings.commandBlockDirection), 3);
                TileEntityCommandBlock te = (TileEntityCommandBlock)world.func_175625_s(spawn.func_177979_c(3).func_177982_a(ConfigOptions.commandSettings.commandBlockPos.x, ConfigOptions.commandSettings.commandBlockPos.y, ConfigOptions.commandSettings.commandBlockPos.z));
                te.func_145993_a().func_145752_a(ConfigOptions.commandSettings.commandBlockCommand);
                te.func_184253_b(ConfigOptions.commandSettings.commandBlockAuto);
            }
        }
    }

    private static void mainSpawn(World world, BlockPos spawn) {
        for (int x = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); x <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++x) {
            for (int z = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); z <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++z) {
                BlockPos pos = new BlockPos(spawn.func_177958_n() + x, spawn.func_177956_o(), spawn.func_177952_p() + z);
                world.func_180501_a(pos.func_177979_c(3), Blocks.field_150357_h.func_176223_P(), 2);
                world.func_180501_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P(), 2);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        block4: {
            EntityPlayer player;
            block5: {
                player = event.player;
                if (!(player.func_130014_f_().func_72912_H().func_76067_t() instanceof WorldTypeVoid)) break block4;
                if (player.func_180470_cg() == null) break block5;
                if (EntityPlayer.func_180467_a((World)player.func_130014_f_(), (BlockPos)player.func_180470_cg(), (boolean)true) != null) break block4;
            }
            IslandPos iPos = IslandManager.getPlayerIsland(player.func_146103_bH().getId());
            BlockPos pos = new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0);
            if (iPos != null) {
                pos = new BlockPos(iPos.getX() * ConfigOptions.islandSettings.islandDistance, ConfigOptions.islandSettings.islandYLevel, iPos.getY() * ConfigOptions.islandSettings.islandDistance);
            }
            IslandManager.tpPlayerToPos(player, pos, iPos);
        }
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        VoidIslandControlSaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        VoidIslandControlSaveData.setDirty(0);
    }

    @SubscribeEvent
    public static PlayerInteractEvent spawnProtection(PlayerInteractEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        if (!ConfigOptions.islandSettings.spawnProtection || Math.abs(player.field_70165_t) > (double)ConfigOptions.islandSettings.protectionBuildRange || Math.abs(player.field_70161_v) > (double)ConfigOptions.islandSettings.protectionBuildRange) {
            return event;
        }
        if (!player.func_184812_l_() && event.isCancelable()) {
            event.setCanceled(true);
        }
        return null;
    }
}

