/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.network;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.flux.api.network.PlayerAccess;

public class FluxPlayer
implements INBTSyncable {
    private UUID player_uuid_online;
    private UUID player_uuid_offline;
    private String player_name;
    private PlayerAccess player_access;
    public static UUID INVALID = new UUID(0L, 0L);

    FluxPlayer() {
    }

    public static FluxPlayer createFluxPlayer(String username, PlayerAccess access) {
        boolean isOffline;
        FluxPlayer player = new FluxPlayer();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        boolean bl = isOffline = !server.func_71266_T();
        if (!isOffline) {
            PlayerProfileCache cache = server.func_152358_ax();
            GameProfile profile = cache.func_152655_a(username);
            if (profile != null) {
                player.player_uuid_online = profile.getId();
            } else {
                isOffline = true;
            }
        }
        if (isOffline) {
            player.player_uuid_online = new UUID(0L, 0L);
            player.player_uuid_offline = EntityPlayer.func_175147_b((String)username);
        }
        player.player_name = username;
        player.player_access = access;
        return player;
    }

    public static FluxPlayer createFluxPlayer(EntityPlayer ePlayer, PlayerAccess access) {
        FluxPlayer player = new FluxPlayer();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        GameProfile profile = ePlayer.func_146103_bH();
        if (server.func_71266_T()) {
            player.player_uuid_online = EntityPlayer.func_146094_a((GameProfile)profile);
        } else {
            player.player_uuid_online = new UUID(0L, 0L);
            player.player_uuid_offline = FluxPlayer.getOfflineUUID(ePlayer);
        }
        player.player_name = profile.getName();
        player.player_access = access;
        return player;
    }

    public FluxPlayer(NBTTagCompound tag) {
        this.readData(tag, NBTHelper.SyncType.SAVE);
    }

    public UUID getOnlineUUID() {
        if (FluxPlayer.valid(this.player_uuid_online)) {
            return this.player_uuid_online;
        }
        return this.getOfflineUUID();
    }

    public UUID getOfflineUUID() {
        if (this.player_uuid_offline == null) {
            this.player_uuid_offline = EntityPlayer.func_175147_b((String)this.player_name);
        }
        return this.player_uuid_offline;
    }

    public static UUID getOnlineUUID(EntityPlayer player) {
        GameProfile profile = player.func_146103_bH();
        return EntityPlayer.func_146094_a((GameProfile)profile);
    }

    public static UUID getOfflineUUID(EntityPlayer player) {
        GameProfile profile = player.func_146103_bH();
        return EntityPlayer.func_175147_b((String)profile.getName());
    }

    public String getCachedName() {
        return this.player_name;
    }

    public PlayerAccess getAccess() {
        return this.player_access;
    }

    public void setAccess(PlayerAccess access) {
        this.player_access = access;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.player_uuid_online = nbt.func_186857_a("playerUUID");
        this.player_name = nbt.func_74779_i("cachedName");
        this.player_access = PlayerAccess.values()[nbt.func_74771_c("playerAccess")];
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_186854_a("playerUUID", this.player_uuid_online);
        nbt.func_74778_a("cachedName", this.player_name);
        nbt.func_74774_a("playerAccess", (byte)this.player_access.ordinal());
        return nbt;
    }

    public boolean matches(EntityPlayer player) {
        if (FluxPlayer.getOnlineUUID(player).equals(this.getOnlineUUID())) {
            return true;
        }
        if (FluxPlayer.getOfflineUUID(player).equals(this.getOfflineUUID())) {
            UUID online = player.func_146103_bH().getId();
            if (online != null) {
                this.player_uuid_online = online;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluxPlayer) {
            FluxPlayer player = (FluxPlayer)obj;
            return player.player_uuid_online.equals(this.player_uuid_online) || player.getOnlineUUID().equals(this.getOnlineUUID()) && player.player_access.equals((Object)this.player_access);
        }
        return false;
    }

    public static boolean valid(UUID uuid) {
        return uuid != null && !uuid.equals(INVALID);
    }
}

