/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.api.tiles.IFluxPlug;
import sonar.flux.api.tiles.IFluxPoint;
import sonar.flux.api.tiles.IFluxStorage;

public class FluxCache<T extends IFluxListenable> {
    public static final FluxCache flux = new FluxCache<IFluxListenable>(IFluxListenable.class);
    public static final FluxCache plug = new FluxCache<IFluxPlug>(IFluxPlug.class);
    public static final FluxCache point = new FluxCache<IFluxPoint>(IFluxPoint.class);
    public static final FluxCache storage = new FluxCache<IFluxStorage>(IFluxStorage.class);
    public static final FluxCache controller = new FluxCache<IFluxController>(IFluxController.class);
    public Class<T> clazz;
    public static final List<FluxCache> types = Lists.newArrayList((Object[])new FluxCache[]{flux, plug, point, storage, controller});

    public FluxCache(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static List<FluxCache> getValidTypes(IFluxListenable tile) {
        ArrayList<FluxCache> valid = new ArrayList<FluxCache>();
        for (FluxCache handler : types) {
            if (!handler.clazz.isInstance(tile)) continue;
            valid.add(handler);
        }
        return valid;
    }
}

