/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RitualEntropy
extends Ritual {
    public static final String CHEST_RANGE = "chest";
    final HashMap<Item, Integer> indexed = new HashMap();

    public RitualEntropy() {
        super("ritualEntropy", 0, 1000, "ritual.animus.ritualEntropy");
        this.addBlockRange(CHEST_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tileInventory = world.func_175625_s((BlockPos)chestRange.getContainedPositions(masterPos).get(0));
        if (!masterRitualStone.getWorldObj().field_72995_K && tileInventory != null && tileInventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            if (currentEssence < this.getRefreshCost()) {
                network.causeNausea();
                return;
            }
            for (int slot = 0; slot < ((IInventory)tileInventory).func_70302_i_(); ++slot) {
                int cobble;
                ItemStack stack = ((IInventory)tileInventory).func_70301_a(slot);
                if (stack.func_190926_b() || stack.func_77969_a(new ItemStack(Blocks.field_150347_e)) || (cobble = this.getCobbleValue(new ArrayList<Item>(), stack, 0)) <= 0) continue;
                ((IInventory)tileInventory).func_70298_a(slot, 1);
                while (cobble > 0) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)tileInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)), (ItemStack)new ItemStack(Blocks.field_150347_e, cobble > 64 ? 64 : cobble), (boolean)false);
                    cobble -= cobble > 64 ? 64 : cobble;
                }
            }
            network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.entropy", new Object[0]), this.getRefreshCost()));
        }
    }

    public int getRefreshCost() {
        return 1;
    }

    public int getRefreshTime() {
        return 1;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                if (x == 0 && y == 0) continue;
                components.accept(new RitualComponent(new BlockPos(x, 0, y), EnumRuneType.EARTH));
            }
        }
        components.accept(new RitualComponent(new BlockPos(-2, 0, -2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-2, 0, 2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(2, 0, -2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(2, 0, 2), EnumRuneType.EARTH));
    }

    public Ritual getNewCopy() {
        return new RitualEntropy();
    }

    public int getCobbleValue(List<Item> fetchList, ItemStack input, int layer) {
        if (this.indexed.get(input.func_77973_b()) != null) {
            return this.indexed.get(input.func_77973_b());
        }
        if (fetchList.contains(input.func_77973_b())) {
            return 1;
        }
        if (layer > 8) {
            return 0;
        }
        ++layer;
        fetchList.add(input.func_77973_b());
        int rtn = 1;
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            Object components;
            if (recipe.func_77571_b().func_190926_b() || !recipe.func_77571_b().func_77969_a(input)) continue;
            rtn += recipe.func_192400_c().size();
            if (recipe instanceof ShapelessRecipes) {
                components = ((ShapelessRecipes)recipe).field_77579_b;
            } else if (recipe instanceof ShapedRecipes) {
                components = Collections.singletonList(((ShapedRecipes)recipe).field_77574_d);
            } else {
                if (!(recipe instanceof ShapedOreRecipe)) continue;
                components = Collections.singletonList(recipe.func_192400_c());
            }
            if (components == null) continue;
            for (Object component : components) {
                if (component instanceof ItemStack) {
                    rtn += this.getCobbleValue(fetchList, (ItemStack)component, layer);
                    continue;
                }
                if (!(component instanceof Collection)) continue;
                if (((Collection)component).contains(new ItemStack(Blocks.field_150347_e))) {
                    ++rtn;
                    continue;
                }
                Collection recipeItemCollection = (Collection)component;
                int value = -1;
                for (Object option : recipeItemCollection) {
                    if (!(option instanceof ItemStack)) continue;
                    int v = this.getCobbleValue(fetchList, (ItemStack)option, layer);
                    value = value == -1 || v < value && v > 1 ? v : value;
                }
                rtn += value == -1 ? 1 : value;
            }
        }
        System.out.printf("Returning %d for item %s on layer %d\n", rtn, input.func_82833_r(), layer);
        this.indexed.put(input.func_77973_b(), rtn);
        return rtn;
    }
}

