/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.handlers;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import com.teamdman.animus.AnimusConfig;
import com.teamdman.animus.registry.AnimusBlocks;
import com.teamdman.animus.registry.AnimusItems;
import com.teamdman.animus.slots.SlotNoPickup;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onPlaySoundEvent(PlaySoundEvent e) {
        if (AnimusConfig.general.muteWither && e.getName().equals("entity.wither.spawn")) {
            e.setResultSound(null);
        }
        if (AnimusConfig.general.muteDragon && e.getName().equals("entity.enderdragon.death")) {
            e.setResultSound(null);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent eventArgs) {
        Container open = eventArgs.player.field_71069_bz;
        if (open == null) {
            return;
        }
        int frags = 0;
        for (int i = 0; i < open.field_75151_b.size(); ++i) {
            Slot repl;
            boolean isFrag;
            Slot slot = (Slot)open.field_75151_b.get(i);
            boolean bl = isFrag = slot.func_75216_d() && slot.func_75211_c().func_77973_b() == AnimusItems.FRAGMENTHEALING;
            if (isFrag) {
                ++frags;
            }
            if (slot instanceof SlotNoPickup) {
                if (!eventArgs.player.field_71075_bZ.field_75098_d && slot.func_75216_d() && slot.func_75211_c().func_77973_b() == AnimusItems.FRAGMENTHEALING) continue;
                repl = new Slot(slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
                repl.field_75222_d = slot.field_75222_d;
                open.field_75151_b.set(i, repl);
                continue;
            }
            if (!isFrag || eventArgs.player.field_71075_bZ.field_75098_d || slot.getClass() != Slot.class) continue;
            repl = new SlotNoPickup(slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
            repl.field_75222_d = slot.field_75222_d;
            open.field_75151_b.set(i, repl);
        }
        if (eventArgs.player.field_70170_p.func_72820_D() % 20L == 0L && frags >= 9 && !eventArgs.player.field_70170_p.field_72995_K) {
            eventArgs.player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, frags / 9 - 1));
            if (frags >= 35 && eventArgs.player.field_70170_p.func_72820_D() % 200L == 0L) {
                eventArgs.player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 200, 4));
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoined(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLightningBolt) {
            EntityLightningBolt bolt = (EntityLightningBolt)event.getEntity();
            if (event.getWorld().func_180495_p(bolt.func_180425_c().func_177977_b()).func_177230_c() == RegistrarBloodMagicBlocks.LIFE_ESSENCE) {
                event.getWorld().func_175656_a(bolt.func_180425_c().func_177977_b(), AnimusBlocks.BLOCKFLUIDANTIMATTER.func_176223_P());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (AnimusConfig.iFrames.mode == AnimusConfig.Mode.DISABLED) {
            return;
        }
        if (entity instanceof EntityPlayer && !AnimusConfig.iFrames.affectPlayers) {
            return;
        }
        if (!entity.func_184222_aU() && !AnimusConfig.iFrames.affectBosses) {
            return;
        }
        switch (AnimusConfig.iFrames.mode) {
            case WHITELIST: {
                if (!Arrays.stream(AnimusConfig.iFrames.sources).noneMatch(s -> Objects.equals(s, source.func_76355_l()))) break;
                return;
            }
            case BLACKLIST: {
                if (!Arrays.stream(AnimusConfig.iFrames.sources).anyMatch(s -> Objects.equals(s, source.func_76355_l()))) break;
                return;
            }
        }
        entity.field_70172_ad = 0;
        entity.field_70737_aN = 1;
    }
}

