/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.blocks;

import WayofTime.bloodmagic.block.IBMBlock;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import com.teamdman.animus.AnimusConfig;
import com.teamdman.animus.registry.AnimusBlocks;
import com.teamdman.animus.tiles.TileAntimatter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAntimatter
extends Block
implements IVariantProvider,
IBMBlock {
    public static final PropertyBool DECAYING = PropertyBool.func_177716_a((String)"decaying");

    public BlockAntimatter() {
        super(Material.field_151583_m);
    }

    public static EnumActionResult setBlockToAntimatter(World world, BlockPos blockPos, EntityPlayer player) {
        if (world.func_175625_s(blockPos) != null || world.func_180495_p(blockPos).func_185887_b(world, blockPos) == -1.0f) {
            return EnumActionResult.PASS;
        }
        Block seeking = world.func_180495_p(blockPos).func_177230_c();
        world.func_175656_a(blockPos, AnimusBlocks.BLOCKANTIMATTER.func_176223_P().func_177226_a((IProperty)DECAYING, (Comparable)Boolean.valueOf(false)));
        ((TileAntimatter)world.func_175625_s(blockPos)).setSeeking(seeking).setPlayer(player);
        world.func_180497_b(blockPos, AnimusBlocks.BLOCKANTIMATTER, 0, 0);
        return EnumActionResult.SUCCESS;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileAntimatter tile = (TileAntimatter)worldIn.func_175625_s(pos);
        boolean decaying = (Boolean)state.func_177229_b((IProperty)DECAYING);
        if (tile.range <= 0) {
            return;
        }
        for (BlockPos newpos : this.getNeighbours(pos)) {
            if (decaying) {
                if (worldIn.func_180495_p(newpos).func_177230_c() != AnimusBlocks.BLOCKANTIMATTER) continue;
                worldIn.func_175656_a(newpos, this.func_176223_P().func_177226_a((IProperty)DECAYING, (Comparable)Boolean.valueOf(true)));
                worldIn.func_180497_b(newpos, AnimusBlocks.BLOCKANTIMATTER, worldIn.field_73012_v.nextInt(10) + 10, 1);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 0.01f, 0.75f);
                continue;
            }
            if (worldIn.func_175623_d(newpos) || worldIn.func_180495_p(newpos).func_177230_c() != tile.seeking) continue;
            worldIn.func_175656_a(newpos, AnimusBlocks.BLOCKANTIMATTER.func_176223_P().func_177226_a((IProperty)DECAYING, (Comparable)Boolean.valueOf(false)));
            ((TileAntimatter)worldIn.func_175625_s((BlockPos)newpos)).seeking = tile.seeking;
            ((TileAntimatter)worldIn.func_175625_s((BlockPos)newpos)).range = tile.range - 1;
            ((TileAntimatter)worldIn.func_175625_s((BlockPos)newpos)).player = tile.player;
            worldIn.func_180497_b(newpos, AnimusBlocks.BLOCKANTIMATTER, worldIn.field_73012_v.nextInt(25), 1);
            if (tile.player != null) {
                NetworkHelper.getSoulNetwork((EntityPlayer)tile.player).syphonAndDamage(tile.player, new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.antimatter", new Object[0]), AnimusConfig.sigils.antimatterConsumption));
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.01f, 0.75f);
        }
        if (decaying) {
            worldIn.func_175698_g(pos);
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DECAYING) != false ? 1 : 0;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        for (BlockPos newpos : this.getNeighbours(pos)) {
            if (worldIn.func_180495_p(newpos).func_177230_c() != AnimusBlocks.BLOCKANTIMATTER) continue;
            worldIn.func_175656_a(newpos, this.func_176223_P().func_177226_a((IProperty)DECAYING, (Comparable)Boolean.valueOf(true)));
            worldIn.func_180497_b(newpos, AnimusBlocks.BLOCKANTIMATTER, worldIn.field_73012_v.nextInt(10) + 10, 1);
        }
        worldIn.func_175698_g(pos);
    }

    private ArrayList<BlockPos> getNeighbours(BlockPos pos) {
        ArrayList<BlockPos> neighbours = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    neighbours.add(pos.func_177982_a(x, y, z));
                }
            }
        }
        return neighbours;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DECAYING});
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAntimatter();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"normal");
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public ItemBlock getItem() {
        return new ItemBlock((Block)this);
    }
}

