/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus;

import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="animus", name="Animus", category="")
@Mod.EventBusSubscriber(modid="animus")
public class AnimusConfig {
    @Config.Comment(value={"General Options"})
    public static ConfigGeneral general = new ConfigGeneral();
    @Config.Comment(value={"Rituals"})
    public static ConfigRituals rituals = new ConfigRituals();
    @Config.Comment(value={"Sigils"})
    public static ConfigSigils sigils = new ConfigSigils();
    @Config.Comment(value={"Hurt Cooldown (iframes)"})
    public static ConfigHurtCooldown iFrames = new ConfigHurtCooldown();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        System.out.println("Syncing Animus Config");
        if (event.getModID().equals("animus")) {
            ConfigManager.sync((String)event.getModID(), (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class ConfigSigils {
        public int antimatterConsumption = 25;
        public int antimatterRange = 8;
        public int builderRange = 64;
        @Config.Comment(value={"Determines if the transposition sigil is allowed to move unbreakable blocks.", "\t0: Never move unbreakable blocks.", "\t1: Allow moving unbreakables, but prevent setting source _position_ to an unbreakable block.", "\t2: Always allow moving unbreakable blocks."})
        public int transpositionMovesUnbreakables = 1;
        public String[] leechBlacklist = new String[]{"ic2:te"};
    }

    public static class ConfigRituals {
        public boolean killWither = true;
        public int witherCost = 25000;
    }

    public static class ConfigHurtCooldown {
        @Config.Comment(value={"How will the Hurt Cooldown (iframes) of vanilla be affected, per damage source.", "An empty list on [Blacklist] mode will remove the cooldown for all damage types."})
        public Mode mode = Mode.BLACKLIST;
        @Config.Comment(value={"If true, bosses will have no iframes."})
        public boolean affectBosses = false;
        @Config.Comment(value={"If true, players will have no iframes."})
        public boolean affectPlayers = false;
        @Config.Comment(value={"List to be used when evaluating whitelist/blacklist functionality."})
        public String[] sources = new String[]{DamageSource.field_76372_a.func_76355_l(), DamageSource.field_76368_d.func_76355_l(), DamageSource.field_76367_g.func_76355_l(), DamageSource.field_180137_b.func_76355_l(), DamageSource.field_76371_c.func_76355_l(), DamageSource.field_76380_i.func_76355_l()};
    }

    public static enum Mode {
        DISABLED,
        WHITELIST,
        BLACKLIST;

    }

    public static class ConfigGeneral {
        public boolean muteDragon = false;
        public boolean muteWither = false;
        public boolean canKillBuffedMobs = false;
        public int bloodPerApple = 50;
    }
}

