/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei;

import java.util.List;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.item.ItemStack;

public class WorkshopCraftingGridHelper
implements ICraftingGridHelper {
    private final int craftInputSlot1;
    private final int craftOutputSlot;

    public WorkshopCraftingGridHelper(int craftInputSlot1, int craftOutputSlot) {
        this.craftInputSlot1 = craftInputSlot1;
        this.craftOutputSlot = craftOutputSlot;
    }

    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs) {
        int width;
        int height;
        if (inputs.size() > 16) {
            height = 5;
            width = 5;
        } else if (inputs.size() > 9) {
            height = 4;
            width = 4;
        } else if (inputs.size() > 4) {
            height = 3;
            width = 3;
        } else if (inputs.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputs(ingredientGroup, inputs, width, height);
    }

    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs, int width, int height) {
        for (int i = 0; i < inputs.size(); ++i) {
            List<T> recipeItem = inputs.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput(ingredientGroup, index, recipeItem);
        }
    }

    private <T> void setInput(IRecipeLayout recipeLayout, int inputIndex, List<T> input) {
        if (!input.isEmpty()) {
            T firstInput = input.get(0);
            Class<?> ingredientClass = firstInput.getClass();
            IGuiIngredientGroup ingredientsGroup = recipeLayout.getIngredientsGroup(ingredientClass);
            this.setInput(ingredientsGroup, inputIndex, input);
        }
    }

    private <T> void setInput(IGuiIngredientGroup<T> guiIngredients, int inputIndex, List<T> input) {
        guiIngredients.set(this.craftInputSlot1 + inputIndex, input);
    }

    public void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input) {
        int width;
        int height;
        if (input.size() > 16) {
            height = 5;
            width = 5;
        } else if (input.size() > 9) {
            height = 4;
            width = 4;
        } else if (input.size() > 4) {
            height = 3;
            width = 3;
        } else if (input.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputStacks(guiItemStacks, input, width, height);
    }

    public void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input, int width, int height) {
        for (int i = 0; i < input.size(); ++i) {
            List<ItemStack> recipeItem = input.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput((IGuiIngredientGroup)guiItemStacks, index, (List)recipeItem);
        }
    }

    private int getCraftingIndex(int i, int width, int height) {
        int result = i / width * 5 + i % width;
        return result;
    }

    public void setOutput(IGuiItemStackGroup guiItemStacks, List<ItemStack> output) {
        guiItemStacks.set(this.craftOutputSlot, output);
    }
}

