/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="artisanworktables", name="artisanworktables/artisanworktables.module.Worktables")
public class ModuleWorktablesConfig {
    @Config.Comment(value={"Set to true to enable log warnings for duplicate recipe names.", "If you're using a lot of your own recipe names, you can enable this", "from time to time to check that you haven't accidentally used the", "same name twice."})
    public static boolean ENABLE_DUPLICATE_RECIPE_NAME_WARNINGS = false;
    @Config.Comment(value={"Set to false to disable worktables."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_WORKTABLES = true;
    @Config.Comment(value={"Set to false to disable workstations."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_WORKSTATIONS = true;
    @Config.Comment(value={"Set to false to disable workshops."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_WORKSHOPS = true;
    @Config.Comment(value={"Set to false to selectively disable a table type across all table tiers."})
    public static Map<String, Boolean> ENABLE_TABLE_TYPE = new HashMap<String, Boolean>();
    @Config.Comment(value={"If set to true, crafting tools must have sufficient durability remaining to perform the craft.", "If set to false, this restriction is ignored."})
    public static boolean RESTRICT_CRAFT_MINIMUM_DURABILITY;
    @Config.Comment(value={"Worktable fluid capacity (milli-buckets)."})
    @Config.RequiresMcRestart
    public static Map<String, Integer> FLUID_CAPACITY_WORKTABLE;
    @Config.Comment(value={"Workstation fluid capacity (milli-buckets)."})
    @Config.RequiresMcRestart
    public static Map<String, Integer> FLUID_CAPACITY_WORKSTATION;
    @Config.Comment(value={"Workshop fluid capacity (milli-buckets)."})
    @Config.RequiresMcRestart
    public static Map<String, Integer> FLUID_CAPACITY_WORKSHOP;
    public static Client CLIENT;
    public static Pattern PATTERN;

    public static boolean isTierEnabled(EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return ENABLE_WORKTABLES;
            }
            case WORKSTATION: {
                return ENABLE_WORKSTATIONS;
            }
            case WORKSHOP: {
                return ENABLE_WORKSHOPS;
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }

    public static boolean isTypeEnabled(EnumType type) {
        return ENABLE_TABLE_TYPE.get(type.func_176610_l());
    }

    public static boolean patternSlotsEnabledForTier(EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return ModuleWorktablesConfig.PATTERN.ENABLE_PATTERN_CREATION_FOR_WORKTABLES;
            }
            case WORKSTATION: {
                return ModuleWorktablesConfig.PATTERN.ENABLE_PATTERN_CREATION_FOR_WORKSTATIONS;
            }
            case WORKSHOP: {
                return ModuleWorktablesConfig.PATTERN.ENABLE_PATTERN_CREATION_FOR_WORKSHOPS;
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }

    static {
        for (EnumType type : EnumType.values()) {
            ENABLE_TABLE_TYPE.put(type.func_176610_l(), true);
        }
        RESTRICT_CRAFT_MINIMUM_DURABILITY = true;
        FLUID_CAPACITY_WORKTABLE = new HashMap<String, Integer>();
        for (String name : ArtisanAPI.getWorktableNames()) {
            FLUID_CAPACITY_WORKTABLE.put(name, 4000);
        }
        FLUID_CAPACITY_WORKSTATION = new HashMap<String, Integer>();
        for (String name : ArtisanAPI.getWorktableNames()) {
            FLUID_CAPACITY_WORKSTATION.put(name, 8000);
        }
        FLUID_CAPACITY_WORKSHOP = new HashMap<String, Integer>();
        for (String name : ArtisanAPI.getWorktableNames()) {
            FLUID_CAPACITY_WORKSHOP.put(name, 16000);
        }
        CLIENT = new Client();
        PATTERN = new Pattern();
    }

    @Mod.EventBusSubscriber(modid="artisanworktables")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("artisanworktables")) {
                ConfigManager.sync((String)"artisanworktables", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Pattern {
        @Config.Comment(value={"Set to false to prevent players from sneak-clicking to clear the patterns.", "This is useful if you want to provide your own method for clearing patterns."})
        public boolean ENABLE_SNEAK_CLICK_TO_CLEAR = true;
        @Config.Comment(value={"Set to false to disable pattern creation for worktables."})
        public boolean ENABLE_PATTERN_CREATION_FOR_WORKTABLES = true;
        @Config.Comment(value={"Set to false to disable pattern creation for workstations."})
        public boolean ENABLE_PATTERN_CREATION_FOR_WORKSTATIONS = true;
        @Config.Comment(value={"Set to false to disable pattern creation for workshops."})
        public boolean ENABLE_PATTERN_CREATION_FOR_WORKSHOPS = true;
    }

    public static class Client {
        @Config.Comment(value={"Here you can change the gui text highlight color. (Hexadecimal)"})
        public Map<String, String> TEXT_HIGHLIGHT_COLOR = new HashMap<String, String>();

        Client() {
            for (String name : ArtisanAPI.getWorktableNames()) {
                Color color = new Color(EnumType.fromName(name).getTextOutlineColor());
                String hex = String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                this.TEXT_HIGHLIGHT_COLOR.put(name, hex);
            }
        }

        public int getTextHighlightColor(String name) {
            return Integer.decode("0x" + this.TEXT_HIGHLIGHT_COLOR.get(name));
        }
    }
}

