/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.tools.material;

import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterial;
import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterialConverter;
import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterialValidationException;
import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterialValidator;
import com.codetaylor.mc.artisanworktables.modules.tools.material.DataCustomMaterial;
import com.codetaylor.mc.artisanworktables.modules.tools.material.DataCustomMaterialList;
import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class CustomMaterialListConverter {
    private CustomMaterialValidator customMaterialValidator;
    private CustomMaterialConverter customMaterialConverter;

    public CustomMaterialListConverter(CustomMaterialValidator customMaterialValidator, CustomMaterialConverter customMaterialConverter) {
        this.customMaterialValidator = customMaterialValidator;
        this.customMaterialConverter = customMaterialConverter;
    }

    public List<CustomMaterial> convert(DataCustomMaterialList data, Logger logger) {
        ArrayList<CustomMaterial> result = new ArrayList<CustomMaterial>();
        List<DataCustomMaterial> list = data.getList();
        for (DataCustomMaterial dataCustomMaterial : list) {
            try {
                this.customMaterialValidator.validate(dataCustomMaterial);
            }
            catch (CustomMaterialValidationException e) {
                logger.error("", (Throwable)e);
                continue;
            }
            try {
                result.add(this.customMaterialConverter.convert(dataCustomMaterial));
            }
            catch (MalformedRecipeItemException e) {
                logger.error("", (Throwable)e);
            }
        }
        return result;
    }
}

