/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.ogex.Curve;
import java.util.HashMap;
import java.util.Map;

public class OgexAtten {
    private Kind kind;
    private Curve curve;
    private Map<String, Float> params = new HashMap<String, Float>();

    protected void validate() {
    }

    public void setKind(Kind kind) {
        this.kind = kind;
        this.validate();
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setCurve(Curve curve) {
        if (curve != Curve.Linear && curve != Curve.Smooth && curve != Curve.Inverse && curve != Curve.InverseSquare) {
            throw new IllegalArgumentException("Invalid Atten curve:" + (Object)((Object)curve));
        }
        this.curve = curve;
        this.validate();
    }

    public Curve getCurve() {
        return this.curve;
    }

    public void setParam(String name, Float f) {
        if (f == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, f);
            this.validate();
        }
    }

    public Float getParam(String name) {
        return this.params.get(name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.kind) + ", curve=" + (Object)((Object)this.curve) + ", params=" + this.params + "]";
    }

    public static enum Kind {
        Distance("distance"),
        Angle("angle"),
        CosAngle("cos_angle");

        private String ogexName;

        private Kind(String ogexName) {
            this.ogexName = ogexName;
        }

        public String getOgexName() {
            return this.ogexName;
        }

        public static Kind lookup(String ogexName) {
            for (Kind kind : Kind.values()) {
                if (!ogexName.equals(kind.ogexName)) continue;
                return kind;
            }
            return null;
        }
    }
}

