/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex;

import com.github.atomicblom.weirdinggadget.block.WeirdingGadgetBlock;
import com.github.atomicblom.weirdinggadget.client.opengex.Animation;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXAnimationFrameProperty;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXException;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXModel;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXNode;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXState;
import com.github.atomicblom.weirdinggadget.client.opengex.VertexData;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.MeshType;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexAnimation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexGeometryNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexIndexArray;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMaterial;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMesh;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTexture;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexVertexArray;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class OpenGEXModelInstance
implements IBakedModel {
    private final OpenGEXModel model;
    private final IModelState state;
    private final VertexFormat format;
    private final ImmutableMap<String, TextureAtlasSprite> textures;
    private final float[][] nodeMatrices;
    private final boolean gui3d;
    private final boolean smoothLighting;
    private ImmutableList<BakedQuad> quads;

    public OpenGEXModelInstance(OpenGEXModel openGEXModel, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textureSpriteMap, float[][] nodeMatrices, boolean gui3d, boolean smoothLighting) {
        this.model = openGEXModel;
        this.state = state;
        this.format = format;
        this.textures = textureSpriteMap;
        this.nodeMatrices = nodeMatrices;
        this.gui3d = gui3d;
        this.smoothLighting = smoothLighting;
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        if (side != null) {
            return new ArrayList<BakedQuad>();
        }
        if (this.quads == null || blockState != null && ((Boolean)blockState.func_177229_b((IProperty)WeirdingGadgetBlock.RENDER_DYNAMIC)).booleanValue()) {
            float animationTime = 0.0f;
            if (this.state instanceof OpenGEXState) {
                animationTime = ((OpenGEXState)this.state).getTime();
            }
            Optional globalTransform = this.state.apply(Optional.empty());
            float[][] nodeMatrices = this.nodeMatrices;
            if (nodeMatrices == null) {
                nodeMatrices = Animation.calculateTransforms(this.model.getScene(), animationTime, this.model.getAllNodes(), this.model.getNodeParents());
            }
            OpenGEXNode node = this.model.getNode();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (OgexNode ogexNode : node) {
                builder.addAll(new OpenGEXModelInstance(new OpenGEXModel(this.model.getLocation(), ogexNode, this.model.getScene(), this.model.getTextureMap(), this.model.getEnabledNodes(), this.gui3d, this.smoothLighting), this.state, this.format, this.textures, nodeMatrices, this.gui3d, this.smoothLighting).func_188616_a(blockState, side, rand));
            }
            List<String> enabledNodes = this.model.getEnabledNodes();
            if (node instanceof OgexGeometryNode) {
                OgexGeometryNode geometryNode = (OgexGeometryNode)node;
                if (enabledNodes == null || enabledNodes.contains(geometryNode.getName())) {
                    OgexMesh mesh = geometryNode.getGeometry().getMesh();
                    MeshType type = mesh.getType();
                    if (type != MeshType.Quads && type != MeshType.Triangles) {
                        throw new OpenGEXException("Attempting to generate a model for an unsupported OpenGL Mesh Type: " + (Object)((Object)type));
                    }
                    ArrayList<OgexTexture> textures = new ArrayList<OgexTexture>();
                    for (OgexMaterial ogexMaterial : geometryNode.getMaterials()) {
                        textures.add(ogexMaterial.getTexture("diffuse"));
                    }
                    if (textures.isEmpty()) {
                        textures.add(OpenGEXModel.white);
                    }
                    List<OgexVertexArray> vertexArrays = mesh.getVertexArrays();
                    Matrix4f nodeTransformation = new Matrix4f(nodeMatrices[geometryNode.getIndex()]);
                    for (OgexIndexArray indexArray : mesh.getIndexArrays()) {
                        for (long[] polyGroup : (long[][])indexArray.getArray()) {
                            UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
                            Object sprite = this.textures.isEmpty() ? (TextureAtlasSprite)this.textures.get((Object)"missingno") : (textures.get(0) == OpenGEXModel.white ? ModelLoader.White.INSTANCE : (TextureAtlasSprite)this.textures.get((Object)((OgexTexture)textures.get(0)).getTexture()));
                            VertexData[] vertexData = new VertexData[polyGroup.length];
                            for (int i = 0; i < polyGroup.length; ++i) {
                                long longVertexIndex = polyGroup[i];
                                int vertexIndex = (int)longVertexIndex;
                                float[] positionArray = null;
                                float[] normalArray = null;
                                float[] texcoordArray = null;
                                float[] colorArray = null;
                                for (OgexVertexArray array : vertexArrays) {
                                    if ("position".equals(array.getName())) {
                                        positionArray = array.getArray2()[vertexIndex];
                                        continue;
                                    }
                                    if ("normal".equals(array.getName())) {
                                        normalArray = array.getArray2()[vertexIndex];
                                        continue;
                                    }
                                    if ("color".equals(array.getName())) {
                                        colorArray = array.getArray2()[vertexIndex];
                                        continue;
                                    }
                                    if (!"texcoord".equals(array.getName())) continue;
                                    texcoordArray = array.getArray2()[vertexIndex];
                                }
                                Vector4f vertex = new Vector4f();
                                Vector3f normal = new Vector3f();
                                vertex.x = positionArray[0];
                                vertex.y = positionArray[1];
                                vertex.z = positionArray[2];
                                vertex.w = 1.0f;
                                normal.x = normalArray[0];
                                normal.y = normalArray[1];
                                normal.z = normalArray[2];
                                nodeTransformation.transform((Tuple4f)vertex);
                                if (globalTransform.isPresent()) {
                                    ((TRSRTransformation)globalTransform.get()).getMatrix().transform((Tuple4f)vertex);
                                }
                                vertex.x /= vertex.w;
                                vertex.y /= vertex.w;
                                vertex.z /= vertex.w;
                                Matrix3f tm = new Matrix3f();
                                nodeTransformation.getRotationScale(tm);
                                tm.invert();
                                tm.transpose();
                                tm.transform((Tuple3f)normal);
                                normal.normalize();
                                quadBuilder.setQuadOrientation(EnumFacing.func_176737_a((float)normal.x, (float)normal.y, (float)normal.z));
                                vertexData[i] = new VertexData(vertex, normal, texcoordArray, colorArray);
                            }
                            Vector3f faceNormal = this.getNormal(vertexData[0].vertex, vertexData[1].vertex, vertexData[2].vertex);
                            for (int j = 0; j < vertexData.length; ++j) {
                                this.putVertexData(quadBuilder, vertexData[j].vertex, faceNormal, faceNormal, vertexData[j].texcoordArray, vertexData[j].colorArray, (TextureAtlasSprite)sprite);
                                if (j != 2 || type != MeshType.Triangles) continue;
                                this.putVertexData(quadBuilder, vertexData[j].vertex, faceNormal, faceNormal, vertexData[j].texcoordArray, vertexData[j].colorArray, (TextureAtlasSprite)sprite);
                            }
                            quadBuilder.setTexture(sprite);
                            builder.add((Object)quadBuilder.build());
                        }
                    }
                }
            }
            this.quads = builder.build();
        }
        return this.quads;
    }

    private Vector3f getNormal(Vector4f p1, Vector4f p2, Vector4f p3) {
        Vector3f output = new Vector3f();
        Vector3f calU = new Vector3f(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        Vector3f calV = new Vector3f(p3.x - p1.x, p3.y - p1.y, p3.z - p1.z);
        output.x = calU.y * calV.z - calU.z * calV.y;
        output.y = calU.z * calV.x - calU.x * calV.z;
        output.z = calU.x * calV.y - calU.y * calV.x;
        output.normalize();
        return output;
    }

    private void putVertexData(UnpackedBakedQuad.Builder builder, Vector4f vertex, Vector3f faceNormal, Vector3f vertexNormal, float[] textureCoordinates, float[] color, TextureAtlasSprite sprite) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{vertex.x, vertex.y, vertex.z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = LightUtil.diffuseLight((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
                    if (color != null) {
                        float v = color.length == 4 ? color[3] : 1.0f;
                        builder.put(e, new float[]{d * color[0], d * color[1], d * color[2], v});
                        continue block6;
                    }
                    builder.put(e, new float[]{d, d, d, 1.0f});
                    continue block6;
                }
                case UV: {
                    int index = this.format.func_177348_c(e).func_177369_e();
                    if (index < textureCoordinates.length / 2) {
                        builder.put(e, new float[]{sprite.func_94214_a((double)(textureCoordinates[index * 2] * 16.0f)), sprite.func_94207_b((double)((1.0f - textureCoordinates[index * 2 + 1]) * 16.0f)), 0.0f, 1.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (vertexNormal != null) {
                        builder.put(e, new float[]{vertexNormal.x, vertexNormal.y, vertexNormal.z, 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        TextureAtlasSprite particle = (TextureAtlasSprite)this.textures.get((Object)"particle");
        if (particle == null) {
            particle = (TextureAtlasSprite)this.textures.values().asList().get(0);
        }
        return particle;
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public OpenGEXModelInstance getAnimatedModel(IBlockState state) {
        OpenGEXState s;
        IExtendedBlockState exState;
        if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains((Object)OpenGEXAnimationFrameProperty.instance) && (s = (OpenGEXState)exState.getValue((IUnlistedProperty)OpenGEXAnimationFrameProperty.instance)) != null) {
            OgexAnimation animation = null;
            return new OpenGEXModelInstance(this.model, new OpenGEXState(animation, s.getTime(), this.state), this.format, this.textures, this.nodeMatrices, this.gui3d, this.smoothLighting);
        }
        return this;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.state, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

