/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex;

import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXModelInstance;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXNode;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXState;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMaterial;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMatrixTransform;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexScene;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTexture;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.FMLLog;

public class OpenGEXModel
implements IModel {
    public static OgexTexture white = new OgexTexture();
    private final OgexScene scene;
    private final ImmutableMap<String, ResourceLocation> textureMap;
    private final List<String> enabledNodes;
    private final OgexTexture defaultTexture = new OgexTexture();
    private final ResourceLocation location;
    private final OpenGEXNode node;
    private Integer[] nodeParents;
    private OgexNode[] allNodes;
    private boolean gui3d;
    private boolean smoothLighting;

    public OpenGEXModel(ResourceLocation location, OgexScene scene) {
        this(location, scene, scene, OpenGEXModel.buildTextures(scene.getMaterials()), null, true, true);
        this.defaultTexture.setTexture("missingno");
    }

    public OpenGEXModel(ResourceLocation location, OpenGEXNode node, OgexScene scene, ImmutableMap<String, ResourceLocation> textures, List<String> enabledNodes, boolean gui3d, boolean smoothLighting) {
        this.location = location;
        this.node = node;
        this.scene = scene;
        this.textureMap = textures;
        this.enabledNodes = enabledNodes;
        this.gui3d = gui3d;
        this.smoothLighting = smoothLighting;
        this.arrangeForRendering();
    }

    private void arrangeForRendering() {
        Stack<OpenGEXNode> queue = new Stack<OpenGEXNode>();
        queue.push(this.scene);
        HashBiMap nodeIndices = HashBiMap.create();
        HashMap nodeParents = Maps.newHashMap();
        int currentIndex = 0;
        while (!queue.empty()) {
            Iterable node = (Iterable)queue.pop();
            if (node instanceof OgexNode) {
                OgexNode ogexNode = (OgexNode)node;
                if (!nodeIndices.containsKey((Object)node)) {
                    nodeIndices.put((Object)ogexNode, (Object)currentIndex);
                    ogexNode.setIndex(currentIndex);
                    ++currentIndex;
                }
            }
            for (OgexNode ogexNode : node) {
                nodeIndices.put((Object)ogexNode, (Object)currentIndex);
                nodeParents.put(currentIndex, nodeIndices.get((Object)node));
                queue.push(ogexNode);
                ogexNode.setIndex(currentIndex);
                ++currentIndex;
            }
        }
        this.allNodes = new OgexNode[nodeParents.size()];
        this.nodeParents = new Integer[nodeParents.size()];
        BiMap inverse = nodeIndices.inverse();
        for (Map.Entry entry : nodeParents.entrySet()) {
            Integer key = (Integer)entry.getKey();
            OgexNode ogexNode = (OgexNode)inverse.get((Object)key);
            Integer value = (Integer)entry.getValue();
            this.allNodes[key.intValue()] = ogexNode;
            this.nodeParents[key.intValue()] = value;
        }
    }

    private static ImmutableMap<String, ResourceLocation> buildTextures(List<OgexMaterial> materials) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (OgexMaterial t : materials) {
            String path = t.getTexture("diffuse").getTexture();
            String location = OpenGEXModel.getLocation(path);
            builder.put((Object)path, (Object)new ResourceLocation(location));
        }
        builder.put((Object)"particle", (Object)new ResourceLocation("#particle"));
        return builder.build();
    }

    private static String getLocation(String path) {
        if (path.endsWith(".png")) {
            path = path.substring(0, path.length() - ".png".length());
        }
        if (!path.startsWith("#")) {
            path = "#" + path;
        }
        return path;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections2.filter((Collection)this.getTextureMap().values(), loc -> !loc.func_110623_a().startsWith("#"));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TextureAtlasSprite missing = bakedTextureGetter.apply(new ResourceLocation("missingno"));
        for (Map.Entry e : this.getTextureMap().entrySet()) {
            String key = (String)e.getKey();
            if (((ResourceLocation)e.getValue()).func_110623_a().startsWith("#")) {
                FMLLog.severe((String)"unresolved texture '%s' for OGEX model '%s'", (Object[])new Object[]{((ResourceLocation)e.getValue()).func_110623_a(), this.location});
                builder.put((Object)key, (Object)missing);
                continue;
            }
            TextureAtlasSprite apply = bakedTextureGetter.apply((ResourceLocation)e.getValue());
            builder.put((Object)key, (Object)apply);
        }
        builder.put((Object)"missingno", (Object)missing);
        return new OpenGEXModelInstance(this, state, format, (ImmutableMap<String, TextureAtlasSprite>)builder.build(), null, this.gui3d, this.smoothLighting);
    }

    public IModelState getDefaultState() {
        return new OpenGEXState(null, 1.0f);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ArrayList enabledNodes = null;
        for (Map.Entry entrySet : customData.entrySet()) {
            if (!"enabled-nodes".equals(entrySet.getKey())) continue;
            enabledNodes = Lists.newArrayList();
            for (JsonElement jsonElement : new JsonParser().parse((String)entrySet.getValue()).getAsJsonArray()) {
                enabledNodes.add(jsonElement.getAsString());
            }
        }
        return new OpenGEXModel(this.location, this.node, this.scene, this.textureMap, enabledNodes, this.gui3d, this.smoothLighting);
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this.getTextureMap().entrySet()) {
            String path = (String)e.getKey();
            String loc = OpenGEXModel.getLocation(path);
            if (textures.containsKey((Object)loc)) {
                String newLoc = (String)textures.get((Object)loc);
                if (newLoc == null) {
                    newLoc = OpenGEXModel.getLocation(path);
                }
                builder.put(e.getKey(), (Object)new ResourceLocation(newLoc));
                continue;
            }
            builder.put(e);
        }
        return new OpenGEXModel(this.location, this.getNode(), this.scene, (ImmutableMap<String, ResourceLocation>)builder.build(), this.getEnabledNodes(), this.gui3d, this.smoothLighting);
    }

    public OpenGEXNode getNode() {
        return this.node;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public ImmutableMap<String, ResourceLocation> getTextureMap() {
        return this.textureMap;
    }

    public OgexNode[] getAllNodes() {
        return this.allNodes;
    }

    public Integer[] getNodeParents() {
        return this.nodeParents;
    }

    public OgexScene getScene() {
        return this.scene;
    }

    public List<String> getEnabledNodes() {
        return this.enabledNodes;
    }

    public IModel smoothLighting(boolean value) {
        if (value == this.smoothLighting) {
            return this;
        }
        return new OpenGEXModel(this.location, this.node, this.scene, this.textureMap, this.enabledNodes, this.gui3d, this.smoothLighting);
    }

    public IModel gui3d(boolean value) {
        if (value == this.gui3d) {
            return this;
        }
        return new OpenGEXModel(this.location, this.node, this.scene, this.textureMap, this.enabledNodes, this.gui3d, this.smoothLighting);
    }

    static {
        white.setTexture("builtin/white");
        OgexMatrixTransform ogexMatrixTransform = new OgexMatrixTransform();
        ogexMatrixTransform.setMatrix(OgexMatrixTransform.identity());
        white.addTransform(ogexMatrixTransform);
    }
}

