/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ClientLinked;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Format;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public final class StringUtil {
    private static final Format[] DEFAULT_RAINBOW = new Format[]{Format.RED, Format.BROWN, Format.OLIVE, Format.YELLOW, Format.DARK_GREEN, Format.GREEN, Format.TEAL, Format.BLUE, Format.MAGENTA, Format.PURPLE};

    private StringUtil() {
    }

    @Nonnull
    public static String combineSplit(@Nonnull String[] split, int start, int length, @Nonnull String delimiter) {
        Sanity.nullCheck(split, "Cannot combine a null array");
        Sanity.nullCheck(delimiter, "Delimiter cannot be null");
        Sanity.truthiness(start >= 0, "Negative array indexes are not valid");
        Sanity.truthiness(length > 0, "Cannot combine less than one element of an array");
        StringBuilder builder = new StringBuilder((5 + delimiter.length()) * length);
        for (int x = start; x < split.length && x < start + length; ++x) {
            builder.append(split[x]).append(delimiter);
        }
        builder.setLength(builder.length() - delimiter.length());
        return builder.toString();
    }

    @Nonnull
    public static String combineSplit(@Nonnull String[] split, int start) {
        Sanity.nullCheck(split, "Cannot combine a null array");
        return StringUtil.combineSplit(split, start, split.length - start, " ");
    }

    @Nonnull
    public static String makeRainbow(@Nonnull String message) {
        return StringUtil.makeRainbow(message, DEFAULT_RAINBOW);
    }

    @Nonnull
    public static String makeRainbow(@Nonnull String message, @Nonnull Format[] colorOrder) {
        Sanity.safeMessageCheck(message);
        Sanity.nullCheck(colorOrder, "Color order cannot be null");
        for (Format format : colorOrder) {
            if (format.isColor()) continue;
            throw new IllegalArgumentException("Color order must contain only colors");
        }
        StringBuilder builder = new StringBuilder(message.length() * 3);
        int count = 0;
        for (char c : message.toCharArray()) {
            if (c != ' ' && c != '\t') {
                builder.append(colorOrder[count++ % colorOrder.length].toString());
            }
            builder.append(c);
        }
        return builder.toString();
    }

    @Nonnull
    public static String toLowerCase(@Nonnull ClientLinked linked, @Nonnull String input) {
        Sanity.nullCheck(linked, "ClientLinked cannot be null");
        return StringUtil.toLowerCase(linked.getClient(), input);
    }

    @Nonnull
    public static String toLowerCase(@Nonnull Client client, @Nonnull String input) {
        Sanity.nullCheck(client, "Client cannot be null");
        Sanity.nullCheck(input, "Input cannot be null");
        return client.getServerInfo().getCaseMapping().toLowerCase(input);
    }
}

