/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth;

import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.auth.element.AccountName;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public abstract class AbstractAccountProtocol
implements AccountName {
    private final Client client;
    private String accountName;

    protected AbstractAccountProtocol(@Nonnull Client client, @Nonnull String accountName) {
        this.client = Sanity.nullCheck(client, "Client cannot be null");
        this.accountName = Sanity.safeMessageCheck(accountName, "Account name");
    }

    @Override
    @Nonnull
    public Client getClient() {
        return this.client;
    }

    @Override
    @Nonnull
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public void setAccountName(@Nonnull String accountName) {
        this.accountName = Sanity.safeMessageCheck(accountName, "Account name");
    }

    @Override
    public final void startAuthentication() {
        this.client.sendRawLineImmediately(this.getAuthentication());
    }

    @Nonnull
    protected abstract String getAuthentication();

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("account", this.getAccountName()).toString();
    }
}

