/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportParameterValueRequired;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerISupportException;

public class DefaultISupportPrefix
extends DefaultISupportParameterValueRequired
implements ISupportParameter.Prefix {
    private static final Pattern PATTERN = Pattern.compile("\\(([a-zA-Z]+)\\)([^ ]+)");
    private final List<ChannelUserMode> modes;

    public DefaultISupportPrefix(@Nonnull Client client, @Nonnull String name, @Nullable String value) {
        super(client, name, value);
        if (value == null) {
            throw new KittehServerISupportException(name, "No prefixes defined");
        }
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.find()) {
            throw new KittehServerISupportException(name, "Data does not match expected pattern");
        }
        String modes = matcher.group(1);
        String display = matcher.group(2);
        if (modes.length() != display.length()) {
            throw new KittehServerISupportException(name, "Prefix and mode size mismatch");
        }
        ArrayList<DefaultChannelUserMode> prefixList = new ArrayList<DefaultChannelUserMode>();
        for (int index = 0; index < modes.length(); ++index) {
            prefixList.add(new DefaultChannelUserMode(client, modes.charAt(index), display.charAt(index)));
        }
        this.modes = Collections.unmodifiableList(prefixList);
    }

    @Override
    @Nonnull
    public List<ChannelUserMode> getModes() {
        return this.modes;
    }
}

