/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportParameterValueRequired;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerISupportException;

public class DefaultISupportChanModes
extends DefaultISupportParameterValueRequired
implements ISupportParameter.ChanModes {
    private final List<ChannelMode> modes;

    public DefaultISupportChanModes(@Nonnull Client client, @Nonnull String name, @Nullable String value) {
        super(client, name, value);
        if (value == null) {
            throw new KittehServerISupportException(name, "No modes defined");
        }
        String[] modes = value.split(",");
        ArrayList<DefaultChannelMode> modesList = new ArrayList<DefaultChannelMode>();
        for (int typeId = 0; typeId < modes.length && typeId < 4; ++typeId) {
            for (char mode : modes[typeId].toCharArray()) {
                ChannelMode.Type type;
                switch (typeId) {
                    case 0: {
                        type = ChannelMode.Type.A_MASK;
                        break;
                    }
                    case 1: {
                        type = ChannelMode.Type.B_PARAMETER_ALWAYS;
                        break;
                    }
                    case 2: {
                        type = ChannelMode.Type.C_PARAMETER_ON_SET;
                        break;
                    }
                    default: {
                        type = ChannelMode.Type.D_PARAMETER_NEVER;
                    }
                }
                modesList.add(new DefaultChannelMode(client, mode, type));
            }
        }
        this.modes = Collections.unmodifiableList(modesList);
    }

    @Override
    @Nonnull
    public List<ChannelMode> getModes() {
        return this.modes;
    }
}

