/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelModeCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.KickCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.TopicCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultStaleable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultChannel
extends DefaultStaleable
implements Channel {
    private final ModeStatusList<ChannelMode> channelModes;
    private final Map<Character, List<ModeInfo>> modeInfoLists;
    private final Map<String, SortedSet<ChannelUserMode>> modes;
    private final List<String> names;
    private final Map<String, User> nickMap;
    private final List<User> users;
    private final boolean complete;
    private final Channel.Topic topic;
    private final DefaultChannelCommands commands;

    public DefaultChannel(@Nonnull Client.WithManagement client, @Nonnull String name, @Nonnull Channel.Topic topic, @Nonnull ModeStatusList<ChannelMode> channelModes, @Nonnull Map<Character, List<ModeInfo>> modeInfoLists, @Nonnull Map<String, SortedSet<ChannelUserMode>> modes, @Nonnull List<String> names, @Nonnull Map<String, User> nickMap, @Nonnull List<User> users, boolean complete, @Nonnull DefaultChannelCommands commands) {
        super(client, name);
        this.complete = complete;
        this.channelModes = channelModes;
        this.topic = topic;
        this.commands = commands;
        this.modeInfoLists = modeInfoLists;
        this.modes = Collections.unmodifiableMap(modes);
        this.names = Collections.unmodifiableList(names);
        this.nickMap = Collections.unmodifiableMap(nickMap);
        this.users = Collections.unmodifiableList(users);
    }

    public boolean equals(Object o) {
        return o instanceof DefaultChannel && ((DefaultChannel)o).getClient() == this.getClient() && ((Channel)o).getLowerCaseName().equals(this.getLowerCaseName());
    }

    @Override
    @Nonnull
    public String getMessagingName() {
        return this.getName();
    }

    @Override
    @Nonnull
    public Optional<List<ModeInfo>> getModeInfoList(@Nonnull ChannelMode mode) {
        Sanity.nullCheck(mode, "Mode cannot be null");
        Sanity.truthiness(mode.getType() == ChannelMode.Type.A_MASK, "Mode type must be A, found " + (Object)((Object)mode.getType()));
        return Optional.ofNullable(this.modeInfoLists.get(Character.valueOf(mode.getChar())));
    }

    @Override
    @Nonnull
    public ModeStatusList<ChannelMode> getModes() {
        return this.channelModes;
    }

    @Override
    @Nonnull
    public List<String> getNicknames() {
        return this.names;
    }

    @Override
    @Nonnull
    public Channel.Topic getTopic() {
        return this.topic;
    }

    @Override
    @Nonnull
    public Optional<User> getUser(@Nonnull String nick) {
        Sanity.nullCheck(nick, "Nick cannot be null");
        return Optional.ofNullable(this.nickMap.get(nick));
    }

    @Override
    @Nonnull
    public Optional<SortedSet<ChannelUserMode>> getUserModes(@Nonnull String nick) {
        Sanity.nullCheck(nick, "Nick cannot be null");
        return Optional.ofNullable(this.modes.get(nick));
    }

    @Override
    @Nonnull
    public List<User> getUsers() {
        return this.users;
    }

    @Override
    public boolean hasCompleteUserData() {
        return this.complete;
    }

    @Override
    public void setModeInfoTracking(@Nonnull ChannelMode mode, boolean track) {
        Sanity.nullCheck(mode, "Mode cannot be null");
        Sanity.truthiness(mode.getType() == ChannelMode.Type.A_MASK, "Mode type must be A, found " + (Object)((Object)mode.getType()));
        Sanity.truthiness(mode.getChar() == 'b' || mode.getChar() == 'e' || mode.getChar() == 'I' || mode.getChar() == 'q', "Only modes b, e, I, and q supported");
        Optional<Channel> channel = this.getClient().getActorTracker().getTrackedChannel(this.getName());
        if (!channel.isPresent()) {
            throw new IllegalStateException("Not currently in channel " + this.getName());
        }
        this.getClient().getActorTracker().trackChannelMode(channel.get().getName(), mode, track);
    }

    @Override
    @Nonnull
    public Channel.Commands commands() {
        return this.commands;
    }

    public int hashCode() {
        return this.getLowerCaseName().hashCode() * 2 + this.getClient().hashCode();
    }

    @Override
    @Nonnull
    public String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("name", this.getName()).add("complete", this.complete).add("users", this.users.size()).toString();
    }

    public static class DefaultChannelCommands
    implements Channel.Commands {
        private final String channel;
        private final Client client;

        public DefaultChannelCommands(@Nonnull Client client, @Nonnull String channel) {
            this.client = client;
            this.channel = channel;
        }

        @Override
        @Nonnull
        public ChannelModeCommand mode() {
            return new ChannelModeCommand(this.client, this.channel);
        }

        @Override
        @Nonnull
        public KickCommand kick() {
            return new KickCommand(this.client, this.channel);
        }

        @Override
        @Nonnull
        public TopicCommand topic() {
            return new TopicCommand(this.client, this.channel);
        }
    }
}

