/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultCapabilityState
implements CapabilityState {
    private final Client client;
    private final long creationTime;
    private final boolean disable;
    private final String name;
    @Nullable
    private final String value;

    public DefaultCapabilityState(@Nonnull Client client, @Nonnull String capabilityListItem) {
        this.client = client;
        this.creationTime = System.currentTimeMillis();
        this.disable = capabilityListItem.charAt(0) == '-';
        String remaining = this.disable ? capabilityListItem.substring(1) : capabilityListItem;
        int index = remaining.indexOf(61);
        if (index > -1 && remaining.length() > index + 1) {
            this.name = remaining.substring(0, index);
            this.value = remaining.substring(index + 1);
        } else {
            this.name = index > -1 ? remaining.substring(0, index) : remaining;
            this.value = null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DefaultCapabilityState) {
            DefaultCapabilityState state = (DefaultCapabilityState)o;
            return state.name.equals(this.name) && state.disable == this.disable;
        }
        return false;
    }

    @Override
    public boolean isDisabled() {
        return this.disable;
    }

    @Override
    @Nonnull
    public Client getClient() {
        return this.client;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public int hashCode() {
        return 2 * this.name.hashCode() + (this.disable ? 1 : 0);
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("name", this.name).add("disabled", this.disable).add("value", this.value).toString();
    }
}

