/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class UserModeCommand
extends Command {
    private final List<ModeStatus<UserMode>> changes = new ArrayList<ModeStatus<UserMode>>();

    public UserModeCommand(@Nonnull Client client) {
        super(client);
    }

    @Nonnull
    public UserModeCommand add(boolean add, @Nonnull UserMode mode) {
        return this.addChange(add, mode, null);
    }

    @Nonnull
    public UserModeCommand add(boolean add, @Nonnull UserMode mode, @Nonnull String parameter) {
        return this.addChange(add, mode, Sanity.nullCheck(parameter, "Parameter cannot be null"));
    }

    @Nonnull
    private synchronized UserModeCommand addChange(boolean add, @Nonnull UserMode mode, @Nullable String parameter) {
        Sanity.nullCheck(mode, "Mode cannot be null");
        Sanity.truthiness(mode.getClient() == this.getClient(), "Mode comes from a different Client");
        if (parameter != null) {
            Sanity.safeMessageCheck(parameter, "Parameter");
            this.changes.add(new ModeStatus<UserMode>(add, mode, parameter));
        } else {
            this.changes.add(new ModeStatus<UserMode>(add, mode));
        }
        return this;
    }

    @Override
    public synchronized void execute() {
        if (this.changes.isEmpty()) {
            this.getClient().sendRawLine("MODE " + this.getClient().getNick());
            return;
        }
        this.getClient().sendRawLine("MODE " + this.getClient().getNick() + ' ' + ModeStatusList.of(new ArrayList(this.changes)).getStatusString());
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("changes", this.changes);
    }
}

