/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentMineral;
import modulardiversity.jei.ingredients.Mineral;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class RequirementMineral
extends RequirementEnvironmental<Mineral, ResourceToken> {
    public String name;
    public int oreMin;
    public int oreMax;
    public int amount;

    public RequirementMineral(MachineComponent.IOType actionType, String name, int oreMin, int oreMax, int amount) {
        super(ComponentType.Registry.getComponent((String)"mineral"), actionType);
        this.name = name;
        this.oreMin = oreMin;
        this.oreMax = oreMax;
        this.amount = amount;
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        return "craftcheck.mineral";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.name, this.oreMin, this.oreMax, this.amount);
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            ChunkPos pos = new ChunkPos(tile.func_174877_v());
            ExcavatorHandler.MineralWorldInfo mineral = ExcavatorHandler.getMineralWorldInfo((World)tile.func_145831_w(), (int)pos.field_77276_a, (int)pos.field_77275_b);
            if (token.matches(tile.func_145831_w(), tile.func_174877_v(), mineral)) {
                int depletion = mineral.depletion;
                if (doConsume) {
                    mineral.depletion = Math.max(0, depletion - token.amount);
                    IESaveData.setDirty((int)tile.func_145831_w().field_73011_w.getDimension());
                }
                token.setAmount(token.getAmount() - (ExcavatorHandler.mineralVeinCapacity - depletion));
            }
        }
        return true;
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            ChunkPos pos = new ChunkPos(tile.func_174877_v());
            ExcavatorHandler.MineralWorldInfo mineral = ExcavatorHandler.getMineralWorldInfo((World)tile.func_145831_w(), (int)pos.field_77276_a, (int)pos.field_77275_b);
            if (token.matches(tile.func_145831_w(), tile.func_174877_v(), mineral)) {
                if (doGenerate) {
                    int depletion = mineral.depletion;
                    mineral.depletion = Math.max(0, depletion - token.amount);
                    IESaveData.setDirty((int)tile.func_145831_w().field_73011_w.getDimension());
                }
                token.setAmount(0);
            }
        }
        return true;
    }

    public ComponentRequirement<Mineral> deepCopy() {
        return new RequirementMineral(this.getActionType(), this.name, this.oreMin, this.oreMax, this.amount);
    }

    public ComponentRequirement<Mineral> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementMineral(this.getActionType(), this.name, Misc.applyModifiers(modifiers, "mineral_min", this.getActionType(), this.oreMin, false), Misc.applyModifiers(modifiers, "mineral_max", this.getActionType(), this.oreMax, false), Misc.applyModifiers(modifiers, "mineral", this.getActionType(), this.amount, false));
    }

    public ComponentRequirement.JEIComponent<Mineral> provideJEIComponent() {
        return new JEIComponentMineral(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private String name;
        private int oreMin;
        private int oreMax;
        private int amount;

        public ResourceToken(String name, int oreMin, int oreMax, int amount) {
            this.name = name;
            this.oreMin = oreMin;
            this.oreMax = oreMax;
            this.amount = amount;
        }

        public boolean matches(World world, BlockPos pos, ExcavatorHandler.MineralWorldInfo reservoir) {
            if (reservoir == null) {
                return false;
            }
            ChunkPos chunkPos = new ChunkPos(pos);
            ExcavatorHandler.MineralMix mix = reservoir.mineralOverride != null ? reservoir.mineralOverride : reservoir.mineral;
            int current = ExcavatorHandler.mineralVeinCapacity - reservoir.depletion;
            return mix.name.equals(this.name) && current >= this.oreMin && current <= this.oreMax;
        }

        public int getOreMin() {
            return this.oreMin;
        }

        public int getOreMax() {
            return this.oreMax;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.oreMin = Misc.applyModifiers(modifiers, "mineral_min", ioType, this.oreMin, false);
            this.oreMax = Misc.applyModifiers(modifiers, "mineral_max", ioType, this.oreMax, false);
            this.amount = Misc.applyModifiers(modifiers, "mineral", ioType, this.amount, false);
        }

        @Override
        public boolean isEmpty() {
            return this.amount <= 0;
        }
    }
}

