/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import modulardiversity.components.requirements.RequirementBiome;
import modulardiversity.util.JsonUtil;

public class ComponentBiome
extends ComponentType<RequirementBiome> {
    @Nonnull
    public String getRegistryName() {
        return "biome";
    }

    @Nullable
    public String requiresModid() {
        return null;
    }

    @Nonnull
    public RequirementBiome provideComponent(MachineComponent.IOType ioType, JsonObject requirement) {
        if (requirement.has("biome") && requirement.get("biome").isJsonPrimitive() && requirement.get("biome").getAsJsonPrimitive().isNumber()) {
            int biome = requirement.getAsJsonPrimitive("biome").getAsInt();
            return new RequirementBiome(ioType, biome);
        }
        if (requirement.has("biome") && requirement.get("biome").isJsonArray()) {
            JsonArray biomes = requirement.get("biome").getAsJsonArray();
            ArrayList<Integer> biomesArrayList = new ArrayList<Integer>();
            for (JsonElement i : biomes) {
                if (!i.isJsonPrimitive() || !i.getAsJsonPrimitive().isNumber()) {
                    throw new JsonParseException("The ComponentType 'biome' expects an integer-entry that defines the type of biome! Either your array of biomes is wrong or one of your biomes is not an integer!");
                }
                biomesArrayList.add(i.getAsJsonPrimitive().getAsInt());
            }
            return (RequirementBiome)new RequirementBiome(ioType, biomesArrayList).setPerTick(JsonUtil.getPerTick(requirement));
        }
        throw new JsonParseException("The ComponentType 'biome' expects an integer-entry that defines the type of biome!");
    }
}

