/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class RuleCache {
    private Map<Integer, CachePerWorld> caches = new HashMap<Integer, CachePerWorld>();

    public void reset(World world) {
        CachePerWorld cache = this.caches.get(world.field_73011_w.getDimension());
        if (cache != null) {
            cache.reset();
        }
    }

    public int getCount(World world, Class<? extends Entity> entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        int count = cache.getCount(world, entityType);
        return count;
    }

    public void registerSpawn(World world, Class<? extends Entity> entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerSpawn(world, entityType);
    }

    public void registerDespawn(World world, Class<? extends Entity> entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerDespawn(world, entityType);
    }

    private CachePerWorld getOrCreateCache(World world) {
        CachePerWorld cache = this.caches.get(world.field_73011_w.getDimension());
        if (cache == null) {
            cache = new CachePerWorld();
            this.caches.put(world.field_73011_w.getDimension(), cache);
        }
        return cache;
    }

    private class CachePerWorld {
        private Map<Class, Integer> cachedCounters = new HashMap<Class, Integer>();
        private boolean countDone = false;

        private CachePerWorld() {
        }

        public void reset() {
            this.cachedCounters.clear();
            this.countDone = false;
        }

        private void count(World world) {
            if (this.countDone) {
                return;
            }
            this.countDone = true;
            this.cachedCounters.clear();
            for (Entity entity : world.field_72996_f) {
                if (!(entity instanceof EntityLiving) || ((EntityLiving)entity).func_104002_bU()) continue;
                int cnt = 0;
                if (this.cachedCounters.containsKey(entity.getClass())) {
                    cnt = this.cachedCounters.get(entity.getClass());
                }
                this.cachedCounters.put(entity.getClass(), ++cnt);
            }
        }

        public int getCount(World world, Class<? extends Entity> entityType) {
            this.count(world);
            return this.cachedCounters.getOrDefault(entityType, 0);
        }

        public void registerSpawn(World world, Class<? extends Entity> entityType) {
            this.count(world);
            this.cachedCounters.put(entityType, this.cachedCounters.getOrDefault(entityType, 0) + 1);
        }

        public void registerDespawn(World world, Class<? extends Entity> entityType) {
            this.count(world);
            Integer cnt = this.cachedCounters.getOrDefault(entityType, 0);
            if (cnt > 0) {
                this.cachedCounters.put(entityType, cnt - 1);
            }
        }
    }
}

