/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.proxy;

import com.elytradev.architecture.client.render.model.IArchitectureModel;
import com.elytradev.architecture.client.render.model.OBJSONModel;
import com.elytradev.architecture.common.ArchitectureGuiHandler;
import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.ArchitectureMod;
import com.elytradev.architecture.common.network.ArchitectureNetworking;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class CommonProxy {
    private Map<ResourceLocation, IArchitectureModel> modelCache = Maps.newHashMap();

    public void preInit(FMLPreInitializationEvent e) {
        ArchitectureNetworking.setupNetwork();
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
    }

    public void registerHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ArchitectureMod.INSTANCE, (IGuiHandler)new ArchitectureGuiHandler());
    }

    public void registerRenderers(LoaderState.ModState modState) {
    }

    public void registerCustomRenderers() {
    }

    public IArchitectureModel getModel(String name) {
        ResourceLocation loc = this.modelLocation(name);
        IArchitectureModel model = this.modelCache.get(loc);
        if (model == null) {
            long t0 = System.nanoTime();
            model = OBJSONModel.fromResource(loc);
            this.modelCache.put(loc, model);
            long t1 = System.nanoTime();
            ArchitectureLog.info("Loaded and cached {} in {} nanos.", name, t1 - t0);
        }
        return model;
    }

    public ResourceLocation modelLocation(String path) {
        return new ResourceLocation("architecturecraft", "models/" + path);
    }
}

